/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.baidu.utils;

import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.sms4j.baidu.config.BaiduConfig;
import org.dromara.sms4j.comm.utils.SmsDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduUtils {
    private static final Logger log = LoggerFactory.getLogger(BaiduUtils.class);

    private static String authStringPrefix(String accessKeyId) {
        return "bce-auth-v1/" + accessKeyId + "/" + SmsDateUtils.utcGmt((Date)new Date()) + "/1800";
    }

    private static String canonicalRequest(String host, String action, String clientToken) {
        return "POST\n" + BaiduUtils.canonicalURI(action) + "\n" + BaiduUtils.canonicalQueryString(clientToken) + "\n" + BaiduUtils.canonicalHeaders(host);
    }

    private static String canonicalURI(String action) {
        return URLEncodeUtil.encode((String)action, (Charset)StandardCharsets.UTF_8);
    }

    private static String canonicalQueryString(String clientToken) {
        if (StrUtil.isBlank((CharSequence)clientToken)) {
            return "";
        }
        return "clientToken=" + URLEncodeUtil.encode((String)clientToken, (Charset)StandardCharsets.UTF_8);
    }

    private static String canonicalHeaders(String host) {
        return URLEncodeUtil.encode((String)"host", (Charset)StandardCharsets.UTF_8) + ":" + URLEncodeUtil.encode((String)host, (Charset)StandardCharsets.UTF_8);
    }

    private static String sha256Hex(String key, String str) {
        HMac hMac = new HMac(HmacAlgorithm.HmacSHA256, key.getBytes(StandardCharsets.UTF_8));
        return hMac.digestHex(str, StandardCharsets.UTF_8);
    }

    public static Map<String, String> buildHeaders(BaiduConfig config, String clientToken) {
        String authStringPrefix = BaiduUtils.authStringPrefix(config.getAccessKeyId());
        String signingKey = BaiduUtils.sha256Hex(config.getAccessKeySecret(), BaiduUtils.authStringPrefix(config.getAccessKeyId()));
        String signature = BaiduUtils.sha256Hex(signingKey, BaiduUtils.canonicalRequest(config.getHost(), config.getAction(), clientToken));
        String authorization = authStringPrefix + "//" + signature;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Authorization", authorization);
        headers.put("host", config.getHost());
        headers.put("x-bce-date", SmsDateUtils.normDateGmt8((Date)new Date()));
        return headers;
    }

    public static Map<String, Object> buildBody(String mobile, String template, String signatureId, LinkedHashMap<String, String> contentVar, String custom, String userExtId) {
        HashMap<String, Object> body = new HashMap<String, Object>(4);
        body.put("mobile", mobile);
        body.put("template", template);
        body.put("signatureId", signatureId);
        body.put("contentVar", contentVar);
        if (StrUtil.isNotBlank((CharSequence)custom)) {
            body.put("custom", custom);
        }
        if (StrUtil.isNotBlank((CharSequence)userExtId)) {
            body.put("userExtId", userExtId);
        }
        return body;
    }

    private BaiduUtils() {
    }
}

