/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.budingyun.service;

import cn.hutool.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.budingyun.config.BudingV2Config;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudingV2SmsImpl
extends AbstractSmsBlend<BudingV2Config> {
    private static final Logger log = LoggerFactory.getLogger(BudingV2SmsImpl.class);
    private int retry = 0;
    private static final String URL = "https://smsapi.idcbdy.com";

    protected BudingV2SmsImpl(BudingV2Config config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public BudingV2SmsImpl(BudingV2Config config) {
        super(config);
    }

    public String getSupplier() {
        return "buding_v2";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        SmsResponse smsResponse;
        HashMap<String, String> body = new HashMap<String, String>();
        System.out.println(((BudingV2Config)this.getConfig()).getSignKey());
        System.out.println(((BudingV2Config)this.getConfig()).getSignature());
        if (((BudingV2Config)this.getConfig()).getSignKey() == null && ((BudingV2Config)this.getConfig()).getSignature() == null) {
            throw new SmsBlendException("\u7b7e\u540d\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (((BudingV2Config)this.getConfig()).getSignKey() == null) {
            body.put("sign", ((BudingV2Config)this.getConfig()).getSignature());
        }
        body.put("key", ((BudingV2Config)this.getConfig()).getAccessKeyId());
        body.put("to", phone);
        body.put("content", message);
        Map<String, String> headers = this.getHeaders();
        try {
            smsResponse = this.getResponse(this.http.postFrom("https://smsapi.idcbdy.com/Api/Sent", headers, body));
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry >= ((BudingV2Config)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, message);
    }

    private SmsResponse requestRetry(String phone, String message) {
        this.http.safeSleep(((BudingV2Config)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {" + this.retry + "} \u6b21\u91cd\u65b0\u53d1\u9001");
        return this.sendMessage(phone, message);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        if (resJson == null) {
            return SmsRespUtils.error((String)this.getConfigId());
        }
        return SmsRespUtils.resp((Object)resJson, (boolean)resJson.getBool((Object)"bool"), (String)this.getConfigId());
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        int failed = 0;
        for (String message : messages.values()) {
            SmsResponse smsResponse = this.sendMessage(phone, message);
            if (smsResponse.isSuccess()) continue;
            ++failed;
        }
        return SmsRespUtils.resp((failed == 0 ? 1 : 0) != 0, (String)this.getConfigId());
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.sendMessage(phone, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        int failed = 0;
        for (String phone : phones) {
            SmsResponse smsResponse = this.sendMessage(phone, message);
            if (smsResponse.isSuccess()) continue;
            ++failed;
        }
        return SmsRespUtils.resp((failed == 0 ? 1 : 0) != 0, (String)this.getConfigId());
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        ArrayList<SmsResponse> list = new ArrayList<SmsResponse>();
        for (String phone : phones) {
            SmsResponse smsResponse = this.sendMessage(phone, templateId, messages);
            list.add(smsResponse);
        }
        return SmsRespUtils.resp(list, (boolean)true, (String)this.getConfigId());
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json; charset=utf-8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }
}

