/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.qiniu.service;

import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.qiniu.config.QiNiuConfig;
import org.dromara.sms4j.qiniu.util.QiNiuUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuSmsImpl
extends AbstractSmsBlend<QiNiuConfig> {
    private static final Logger log = LoggerFactory.getLogger(QiNiuSmsImpl.class);
    private int retry = 0;

    public String getSupplier() {
        return "qiniu";
    }

    public QiNiuSmsImpl(QiNiuConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public QiNiuSmsImpl(QiNiuConfig config) {
        super(config);
    }

    @Override
    public SmsResponse sendMessage(String phone, final String message) {
        return this.sendSingleMsg(phone, ((QiNiuConfig)this.getConfig()).getTemplateId(), new LinkedHashMap<String, String>(){
            {
                this.put(((QiNiuConfig)QiNiuSmsImpl.this.getConfig()).getTemplateName(), message);
            }
        });
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        return this.sendSingleMsg(phone, ((QiNiuConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.sendSingleMsg(phone, templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(((QiNiuConfig)this.getConfig()).getTemplateName(), message);
        return this.senMassMsg(phones, ((QiNiuConfig)this.getConfig()).getTemplateId(), params);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        return this.senMassMsg(phones, templateId, messages);
    }

    public SmsResponse handleRes(String url, HashMap<String, Object> params) {
        SmsResponse smsResponse;
        try {
            JSONObject jsonObject = this.http.postJson(url, QiNiuUtils.getHeaderAndSign(url, params, (QiNiuConfig)this.getConfig()), params);
            smsResponse = SmsRespUtils.resp((Object)jsonObject, (boolean)SmsUtils.isEmpty((Object)jsonObject.getStr((Object)"error")), (String)this.getConfigId());
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry >= ((QiNiuConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        this.http.safeSleep(((QiNiuConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.handleRes(url, params);
    }

    private SmsResponse senMassMsg(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        String url = ((QiNiuConfig)this.getConfig()).getBaseUrl() + ((QiNiuConfig)this.getConfig()).getMassMsgUrl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("template_id", templateId);
        params.put("mobiles", phones.toArray());
        params.put("parameters", messages);
        return this.handleRes(url, params);
    }

    private SmsResponse sendSingleMsg(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        String url = ((QiNiuConfig)this.getConfig()).getBaseUrl() + ((QiNiuConfig)this.getConfig()).getSingleMsgUrl();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("mobile", phone);
        hashMap.put("template_id", templateId);
        hashMap.put("parameters", messages);
        log.info("hashMap:{}", hashMap);
        return this.handleRes(url, hashMap);
    }
}

