/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.body;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.CompilationUnit;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.CallableDeclaration;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.nodeTypes.NodeWithJavadoc;
import org.drools.javaparser.ast.nodeTypes.NodeWithMembers;
import org.drools.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.drools.javaparser.ast.nodeTypes.modifiers.NodeWithAccessModifiers;
import org.drools.javaparser.ast.nodeTypes.modifiers.NodeWithStaticModifier;
import org.drools.javaparser.ast.nodeTypes.modifiers.NodeWithStrictfpModifier;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.TypeDeclarationMetaModel;
import org.drools.javaparser.utils.Utils;

public abstract class TypeDeclaration<T extends TypeDeclaration<?>>
extends BodyDeclaration<T>
implements NodeWithSimpleName<T>,
NodeWithJavadoc<T>,
NodeWithMembers<T>,
NodeWithAccessModifiers<T>,
NodeWithStaticModifier<T>,
NodeWithStrictfpModifier<T> {
    private SimpleName name;
    private EnumSet<Modifier> modifiers;
    private NodeList<BodyDeclaration<?>> members;

    public TypeDeclaration() {
        this(null, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new SimpleName(), new NodeList());
    }

    public TypeDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), new SimpleName(name), new NodeList());
    }

    @AllFieldsConstructor
    public TypeDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<BodyDeclaration<?>> members) {
        this(null, modifiers, annotations, name, members);
    }

    public TypeDeclaration(TokenRange tokenRange, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<BodyDeclaration<?>> members) {
        super(tokenRange, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setName(name);
        this.setMembers((NodeList)members);
        this.customInitialization();
    }

    @Override
    public T addMember(BodyDeclaration<?> decl) {
        NodeList<BodyDeclaration<?>> members = this.getMembers();
        members.add(decl);
        return (T)this;
    }

    @Override
    public NodeList<BodyDeclaration<?>> getMembers() {
        return this.members;
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public T setMembers(NodeList<BodyDeclaration<?>> members) {
        Utils.assertNotNull(members);
        if (members == this.members) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.MEMBERS, this.members, members);
        if (this.members != null) {
            this.members.setParentNode(null);
        }
        this.members = members;
        this.setAsParentNodeOf(members);
        return (T)this;
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = modifiers;
        return (T)this;
    }

    @Override
    public T setName(SimpleName name) {
        Utils.assertNotNull(name);
        if (name == this.name) {
            return (T)this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return (T)this;
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i) != node) continue;
            this.members.remove(i);
            return true;
        }
        return super.remove(node);
    }

    public boolean isTopLevelType() {
        return this.getParentNode().map(p -> p instanceof CompilationUnit).orElse(false);
    }

    public List<CallableDeclaration<?>> getCallablesWithSignature(CallableDeclaration.Signature signature) {
        return this.getMembers().stream().filter(m -> m instanceof CallableDeclaration).map(m -> (CallableDeclaration)m).filter(m -> m.getSignature().equals(signature)).collect(Collectors.toList());
    }

    public boolean isNestedType() {
        return this.getParentNode().map(p -> p instanceof TypeDeclaration).orElse(false);
    }

    @Override
    public TypeDeclaration<?> clone() {
        return (TypeDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public TypeDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.typeDeclarationMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i) != node) continue;
            this.members.set(i, (BodyDeclaration)replacementNode);
            return true;
        }
        if (node == this.name) {
            this.setName((SimpleName)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isTypeDeclaration() {
        return true;
    }

    @Override
    public TypeDeclaration asTypeDeclaration() {
        return this;
    }

    @Override
    public void ifTypeDeclaration(Consumer<TypeDeclaration> action) {
        action.accept(this);
    }

    @Override
    public Optional<TypeDeclaration> toTypeDeclaration() {
        return Optional.of(this);
    }
}

