/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.LiteralStringValueExpr;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.StringLiteralExprMetaModel;
import org.drools.javaparser.utils.StringEscapeUtils;
import org.drools.javaparser.utils.Utils;

public final class StringLiteralExpr
extends LiteralStringValueExpr {
    public StringLiteralExpr() {
        this(null, "empty");
    }

    @AllFieldsConstructor
    public StringLiteralExpr(String value) {
        this(null, Utils.escapeEndOfLines(value));
    }

    @Deprecated
    public static StringLiteralExpr escape(String string) {
        return new StringLiteralExpr(Utils.escapeEndOfLines(string));
    }

    public StringLiteralExpr(TokenRange tokenRange, String value) {
        super(tokenRange, value);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    public StringLiteralExpr setEscapedValue(String value) {
        this.value = Utils.escapeEndOfLines(value);
        return this;
    }

    public String asString() {
        return StringEscapeUtils.unescapeJava(this.value);
    }

    public StringLiteralExpr setString(String value) {
        this.value = StringEscapeUtils.escapeJava(value);
        return this;
    }

    @Override
    public StringLiteralExpr clone() {
        return (StringLiteralExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public StringLiteralExprMetaModel getMetaModel() {
        return JavaParserMetaModel.stringLiteralExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isStringLiteralExpr() {
        return true;
    }

    @Override
    public StringLiteralExpr asStringLiteralExpr() {
        return this;
    }

    @Override
    public void ifStringLiteralExpr(Consumer<StringLiteralExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<StringLiteralExpr> toStringLiteralExpr() {
        return Optional.of(this);
    }
}

