/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.type;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.PrimitiveTypeMetaModel;
import org.drools.javaparser.resolution.types.ResolvedPrimitiveType;
import org.drools.javaparser.utils.Utils;

public final class PrimitiveType
extends Type
implements NodeWithAnnotations<PrimitiveType> {
    static final HashMap<String, Primitive> unboxMap = new HashMap();
    private Primitive type;

    public static PrimitiveType booleanType() {
        return new PrimitiveType(Primitive.BOOLEAN);
    }

    public static PrimitiveType charType() {
        return new PrimitiveType(Primitive.CHAR);
    }

    public static PrimitiveType byteType() {
        return new PrimitiveType(Primitive.BYTE);
    }

    public static PrimitiveType shortType() {
        return new PrimitiveType(Primitive.SHORT);
    }

    public static PrimitiveType intType() {
        return new PrimitiveType(Primitive.INT);
    }

    public static PrimitiveType longType() {
        return new PrimitiveType(Primitive.LONG);
    }

    public static PrimitiveType floatType() {
        return new PrimitiveType(Primitive.FLOAT);
    }

    public static PrimitiveType doubleType() {
        return new PrimitiveType(Primitive.DOUBLE);
    }

    public PrimitiveType() {
        this(null, Primitive.INT, new NodeList<AnnotationExpr>());
    }

    public PrimitiveType(Primitive type) {
        this(null, type, new NodeList<AnnotationExpr>());
    }

    @AllFieldsConstructor
    public PrimitiveType(Primitive type, NodeList<AnnotationExpr> annotations) {
        this(null, type, annotations);
    }

    public PrimitiveType(TokenRange tokenRange, Primitive type, NodeList<AnnotationExpr> annotations) {
        super(tokenRange, annotations);
        this.setType(type);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Primitive getType() {
        return this.type;
    }

    public ClassOrInterfaceType toBoxedType() {
        return this.type.toBoxedType();
    }

    public PrimitiveType setType(Primitive type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = type;
        return this;
    }

    @Override
    public String asString() {
        return this.type.asString();
    }

    @Override
    public PrimitiveType setAnnotations(NodeList<AnnotationExpr> annotations) {
        return (PrimitiveType)super.setAnnotations(annotations);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public PrimitiveType clone() {
        return (PrimitiveType)this.accept(new CloneVisitor(), null);
    }

    @Override
    public PrimitiveTypeMetaModel getMetaModel() {
        return JavaParserMetaModel.primitiveTypeMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public PrimitiveType asPrimitiveType() {
        return this;
    }

    @Override
    public void ifPrimitiveType(Consumer<PrimitiveType> action) {
        action.accept(this);
    }

    @Override
    public ResolvedPrimitiveType resolve() {
        return this.getSymbolResolver().toResolvedType(this, ResolvedPrimitiveType.class);
    }

    @Override
    public Optional<PrimitiveType> toPrimitiveType() {
        return Optional.of(this);
    }

    static {
        for (Primitive unboxedType : Primitive.values()) {
            unboxMap.put(unboxedType.nameOfBoxedType, unboxedType);
        }
    }

    public static enum Primitive {
        BOOLEAN("Boolean"),
        CHAR("Character"),
        BYTE("Byte"),
        SHORT("Short"),
        INT("Integer"),
        LONG("Long"),
        FLOAT("Float"),
        DOUBLE("Double");

        final String nameOfBoxedType;
        private String codeRepresentation;

        public ClassOrInterfaceType toBoxedType() {
            return JavaParser.parseClassOrInterfaceType(this.nameOfBoxedType);
        }

        public String asString() {
            return this.codeRepresentation;
        }

        private Primitive(String nameOfBoxedType) {
            this.nameOfBoxedType = nameOfBoxedType;
            this.codeRepresentation = this.name().toLowerCase();
        }
    }
}

