/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.OptionalProperty;
import org.drools.javaparser.metamodel.SuperExprMetaModel;

public final class SuperExpr
extends Expression {
    @OptionalProperty
    private Expression classExpr;

    public SuperExpr() {
        this(null, null);
    }

    @AllFieldsConstructor
    public SuperExpr(Expression classExpr) {
        this(null, classExpr);
    }

    public SuperExpr(TokenRange tokenRange, Expression classExpr) {
        super(tokenRange);
        this.setClassExpr(classExpr);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getClassExpr() {
        return Optional.ofNullable(this.classExpr);
    }

    public SuperExpr setClassExpr(Expression classExpr) {
        if (classExpr == this.classExpr) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.CLASS_EXPR, this.classExpr, classExpr);
        if (this.classExpr != null) {
            this.classExpr.setParentNode(null);
        }
        this.classExpr = classExpr;
        this.setAsParentNodeOf(classExpr);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.classExpr != null && node == this.classExpr) {
            this.removeClassExpr();
            return true;
        }
        return super.remove(node);
    }

    public SuperExpr removeClassExpr() {
        return this.setClassExpr(null);
    }

    @Override
    public SuperExpr clone() {
        return (SuperExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public SuperExprMetaModel getMetaModel() {
        return JavaParserMetaModel.superExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (this.classExpr != null && node == this.classExpr) {
            this.setClassExpr((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isSuperExpr() {
        return true;
    }

    @Override
    public SuperExpr asSuperExpr() {
        return this;
    }

    @Override
    public void ifSuperExpr(Consumer<SuperExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<SuperExpr> toSuperExpr() {
        return Optional.of(this);
    }
}

