/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public final class ConnectionIdExtension
extends HelloExtension {
    private static final int CID_FIELD_LENGTH_BITS = 8;
    private final ConnectionId id;

    private ConnectionIdExtension(ConnectionId id, HelloExtension.ExtensionType type) {
        super(type);
        this.id = id;
    }

    public ConnectionId getConnectionId() {
        return this.id;
    }

    public boolean useDeprecatedCid() {
        return this.getType() != HelloExtension.ExtensionType.CONNECTION_ID;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation((int)(indent + 1));
        sb.append(indentation).append("DTLS Conection ID: ").append((Object)this.id).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    protected int getExtensionLength() {
        return 1 + this.id.length();
    }

    @Override
    protected void writeExtensionTo(DatagramWriter writer) {
        writer.writeVarBytes((Bytes)this.id, 8);
    }

    public static ConnectionIdExtension fromConnectionId(ConnectionId cid, HelloExtension.ExtensionType type) {
        if (cid == null) {
            throw new NullPointerException("cid must not be null!");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null!");
        }
        if (type != HelloExtension.ExtensionType.CONNECTION_ID && type.getReplacementType() != HelloExtension.ExtensionType.CONNECTION_ID) {
            throw new IllegalArgumentException((Object)((Object)type) + " type is not supported as Connection ID!");
        }
        return new ConnectionIdExtension(cid, type);
    }

    public static ConnectionIdExtension fromExtensionDataReader(DatagramReader extensionDataReader, HelloExtension.ExtensionType type) throws HandshakeException {
        if (extensionDataReader == null) {
            throw new NullPointerException("cid must not be null!");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null!");
        }
        if (type != HelloExtension.ExtensionType.CONNECTION_ID && type.getReplacementType() != HelloExtension.ExtensionType.CONNECTION_ID) {
            throw new IllegalArgumentException((Object)((Object)type) + " type is not supported as Connection ID!");
        }
        int availableBytes = extensionDataReader.bitsLeft() / 8;
        if (availableBytes == 0) {
            throw new HandshakeException("Connection id length must be provided!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (availableBytes > 256) {
            throw new HandshakeException("Connection id length too large! 255 max, but has " + (availableBytes - 1), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        int len = extensionDataReader.read(8);
        if (len != availableBytes - 1) {
            throw new HandshakeException("Connection id length " + len + " doesn't match " + (availableBytes - 1) + "!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        if (len == 0) {
            return new ConnectionIdExtension(ConnectionId.EMPTY, type);
        }
        byte[] cid = extensionDataReader.readBytes(len);
        return new ConnectionIdExtension(new ConnectionId(cid), type);
    }
}

