/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.bootstrap.BootstrapHandler;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.resource.LwM2mRootEnabler;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.Link;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.util.StringUtils;

public class RootResource
extends LwM2mClientCoapResource {
    protected CoapServer coapServer;
    protected BootstrapHandler bootstrapHandler;
    protected LwM2mRootEnabler rootEnabler;
    protected LwM2mEncoder encoder;
    protected LwM2mDecoder decoder;

    public RootResource(RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager, BootstrapHandler bootstrapHandler, CoapServer coapServer, LwM2mRootEnabler rootEnabler, LwM2mEncoder encoder, LwM2mDecoder decoder) {
        super("", registrationEngine, endpointsManager);
        this.bootstrapHandler = bootstrapHandler;
        this.setVisible(false);
        this.coapServer = coapServer;
        this.rootEnabler = rootEnabler;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public void handleGET(CoapExchange exchange) {
        Request coapRequest;
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        String URI2 = exchange.getRequestOptions().getUriPathString();
        BootstrapDiscoverResponse response = this.bootstrapHandler.discover(identity, new BootstrapDiscoverRequest(URI2, (Object)(coapRequest = exchange.advanced().getRequest())));
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), Link.serialize((Link[])response.getObjectLinks()), 40);
        }
    }

    public void handleFETCH(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        ContentFormat responseContentFormat = ContentFormat.SENML_CBOR;
        if (exchange.getRequestOptions().hasAccept() && !this.encoder.isSupported(responseContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getAccept()))) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        if (!exchange.getRequestOptions().hasContentFormat()) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            return;
        }
        ContentFormat requestContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        List paths = this.decoder.decodePaths(coapRequest.getPayload(), requestContentFormat);
        ReadCompositeResponse response = this.rootEnabler.read(identity, new ReadCompositeRequest(paths, requestContentFormat, responseContentFormat, (Object)coapRequest));
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.encoder.encodeNodes(response.getContent(), responseContentFormat, this.rootEnabler.getModel()), responseContentFormat.getCode());
        }
    }

    public void handleIPATCH(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        if (!this.decoder.isSupported(contentFormat)) {
            exchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        Map nodes = this.decoder.decodeNodes(coapRequest.getPayload(), contentFormat, null, this.rootEnabler.getModel());
        WriteCompositeResponse response = this.rootEnabler.write(identity, new WriteCompositeRequest(contentFormat, nodes, (Object)coapRequest));
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
        }
    }

    public void handleDELETE(CoapExchange exchange) {
        String URI2 = exchange.getRequestOptions().getUriPathString();
        if (!StringUtils.isEmpty((String)URI2)) {
            exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
            return;
        }
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        BootstrapDeleteResponse response = this.bootstrapHandler.delete(identity, new BootstrapDeleteRequest(URI2, (Object)coapRequest));
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
    }

    public List<Endpoint> getEndpoints() {
        return this.coapServer.getEndpoints();
    }
}

