/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.leshan.client.californium.BaseCertificateVerifier;
import org.eclipse.leshan.client.californium.X509Util;
import org.eclipse.leshan.core.util.Validate;

public class TrustAnchorAssertionCertificateVerifier
extends BaseCertificateVerifier {
    private final X509Certificate[] trustAnchor;

    public TrustAnchorAssertionCertificateVerifier(X509Certificate trustAnchor) {
        Validate.notNull((Object)trustAnchor);
        this.trustAnchor = new X509Certificate[]{trustAnchor};
    }

    @Override
    public CertPath verifyCertificate(Boolean clientUsage, CertificateMessage message, DTLSSession session) throws HandshakeException {
        CertPath certPath;
        CertPath messageChain = message.getCertificateChain();
        this.validateCertificateChainNotEmpty(messageChain, session.getPeer());
        X509Certificate receivedServerCertificate = this.validateReceivedCertificateIsSupported(messageChain, session.getPeer());
        try {
            certPath = X509Util.applyPKIXValidation(messageChain, this.trustAnchor);
        }
        catch (GeneralSecurityException e) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            throw new HandshakeException("Certificate chain could not be validated : server cert chain is empty", alert);
        }
        this.validateSubject(session, receivedServerCertificate);
        return certPath;
    }
}

