/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import java.util.HashMap;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.response.BootstrapResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.server.bootstrap.BootstrapHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapResource
extends LwM2mCoapResource {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapResource.class);
    private static final String QUERY_PARAM_ENDPOINT = "ep=";
    private static final String QUERY_PARAM_PREFERRED_CONTENT_FORMAT = "pct=";
    private final BootstrapHandler bootstrapHandler;

    public BootstrapResource(BootstrapHandler handler) {
        super("bs");
        this.bootstrapHandler = handler;
    }

    public void handlePOST(CoapExchange exchange) {
        Request coapRequest;
        Request request = exchange.advanced().getRequest();
        LOG.trace("POST received : {}", (Object)request);
        if (!CoAP.Type.CON.equals((Object)request.getType())) {
            this.handleInvalidRequest(exchange, "CON CoAP type expected");
            return;
        }
        String endpoint = null;
        ContentFormat preferredContentFomart = null;
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        for (String param : request.getOptions().getUriQuery()) {
            if (param.startsWith(QUERY_PARAM_ENDPOINT)) {
                endpoint = param.substring(QUERY_PARAM_ENDPOINT.length());
                continue;
            }
            if (param.startsWith(QUERY_PARAM_PREFERRED_CONTENT_FORMAT)) {
                try {
                    preferredContentFomart = ContentFormat.fromCode((String)param.substring(QUERY_PARAM_PREFERRED_CONTENT_FORMAT.length()));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.handleInvalidRequest(exchange.advanced(), "Invalid preferre content format (pct) query param : must be a number", e);
                    return;
                }
            }
            String[] tokens = param.split("\\=");
            if (tokens == null || tokens.length != 2) continue;
            additionalParams.put(tokens[0], tokens[1]);
        }
        Identity clientIdentity = this.extractIdentity(request.getSourceContext());
        SendableResponse sendableResponse = this.bootstrapHandler.bootstrap(clientIdentity, new BootstrapRequest(endpoint, preferredContentFomart, additionalParams, (Object)(coapRequest = exchange.advanced().getRequest())));
        BootstrapResponse response = (BootstrapResponse)sendableResponse.getResponse();
        if (response.isSuccess()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        }
        sendableResponse.sent();
    }
}

