/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeDeserializer;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;

public abstract class AbstractNumberDeserializer<T extends Number>
extends AbstractValueTypeDeserializer<T> {
    public AbstractNumberDeserializer(Class<T> clazz, Customization customization) {
        super(clazz, customization);
    }

    protected final Optional<Number> deserializeFormatted(String jsonValue, boolean integerOnly, JsonbContext jsonbContext) {
        if (this.getCustomization() == null || this.getCustomization().getDeserializeNumberFormatter() == null) {
            return Optional.empty();
        }
        JsonbNumberFormatter numberFormat = this.getCustomization().getDeserializeNumberFormatter();
        Locale locale = jsonbContext.getConfigProperties().getLocale(numberFormat.getLocale());
        NumberFormat format = NumberFormat.getInstance(locale);
        ((DecimalFormat)format).applyPattern(numberFormat.getFormat());
        format.setParseIntegerOnly(integerOnly);
        try {
            return Optional.of(format.parse(this.compatibilityChanger(jsonValue, locale)));
        }
        catch (ParseException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.PARSING_NUMBER, jsonValue, numberFormat.getFormat()));
        }
    }

    private String compatibilityChanger(String value, Locale locale) {
        char beforeJdk13GroupSeparator = '\u00a0';
        char frenchGroupingSeparator = DecimalFormatSymbols.getInstance(Locale.FRENCH).getGroupingSeparator();
        if (locale.getLanguage().equals(Locale.FRENCH.getLanguage()) && beforeJdk13GroupSeparator != frenchGroupingSeparator) {
            return value.replace(beforeJdk13GroupSeparator, frenchGroupingSeparator);
        }
        return value;
    }
}

