/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename;

import com.examples.with.different.packagename.Buffer;
import com.examples.with.different.packagename.BufferUnderflowException;
import java.util.ArrayList;
import java.util.EmptyStackException;

public class ArrayStack
extends ArrayList
implements Buffer {
    private static final long serialVersionUID = 2130079159931574599L;

    public ArrayStack() {
    }

    public ArrayStack(int initialSize) {
        super(initialSize);
    }

    public boolean empty() {
        return this.isEmpty();
    }

    public Object peek() throws EmptyStackException {
        int n = this.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        return this.get(n - 1);
    }

    public Object peek(int n) throws EmptyStackException {
        int m = this.size() - n - 1;
        if (m < 0) {
            throw new EmptyStackException();
        }
        return this.get(m);
    }

    public Object pop() throws EmptyStackException {
        int n = this.size();
        if (n <= 0) {
            throw new EmptyStackException();
        }
        return this.remove(n - 1);
    }

    public Object push(Object item) {
        this.add(item);
        return item;
    }

    public int search(Object object) {
        int i = this.size() - 1;
        int n = 1;
        while (i >= 0) {
            Object current = this.get(i);
            if (object == null && current == null || object != null && object.equals(current)) {
                return n;
            }
            --i;
            ++n;
        }
        return -1;
    }

    @Override
    public Object get() {
        int size = this.size();
        if (size == 0) {
            throw new BufferUnderflowException();
        }
        return this.get(size - 1);
    }

    @Override
    public Object remove() {
        int size = this.size();
        if (size == 0) {
            throw new BufferUnderflowException();
        }
        return this.remove(size - 1);
    }
}

