/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.concolic;

import com.examples.with.different.packagename.concolic.MathRuntimeException;
import com.examples.with.different.packagename.concolic.MathUtils;

public class Fraction {
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    private final int denominator;
    private final int numerator;

    public Fraction(int num, int den) {
        int d;
        if (den == 0) {
            throw MathRuntimeException.createArithmeticException("zero denominator in fraction {0}/{1}", num, den);
        }
        if (den < 0) {
            if (num == Integer.MIN_VALUE || den == Integer.MIN_VALUE) {
                throw MathRuntimeException.createArithmeticException("overflow in fraction {0}/{1}, cannot negate", num, den);
            }
            num = -num;
            den = -den;
        }
        if ((d = MathUtils.gcd(num, den)) > 1) {
            num /= d;
            den /= d;
        }
        if (den < 0) {
            num = -num;
            den = -den;
        }
        this.numerator = num;
        this.denominator = den;
    }
}

