/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.concolic;

import com.examples.with.different.packagename.concolic.MathRuntimeException;

public class MathUtils {
    public static int gcd(int p, int q) {
        int t;
        int k;
        int u = p;
        int v = q;
        if (u == 0 || v == 0) {
            if (u == Integer.MIN_VALUE || v == Integer.MIN_VALUE) {
                throw MathRuntimeException.createArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
            }
            return Math.abs(u) + Math.abs(v);
        }
        if (u > 0) {
            u = -u;
        }
        if (v > 0) {
            v = -v;
        }
        for (k = 0; (u & 1) == 0 && (v & 1) == 0 && k < 31; ++k) {
            u /= 2;
            v /= 2;
        }
        if (k == 31) {
            throw MathRuntimeException.createArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
        }
        int n = t = (u & 1) == 1 ? v : -(u / 2);
        while (true) {
            if ((t & 1) == 0) {
                t /= 2;
                continue;
            }
            if (t > 0) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = (v - u) / 2) == 0) break;
        }
        return -u * (1 << k);
    }
}

