/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.concolic;

import com.examples.with.different.packagename.concolic.MalformedURIException;
import com.examples.with.different.packagename.concolic.URIClassifier;
import java.net.MalformedURLException;
import java.net.URL;

public class URI {
    protected String uri;
    protected int colonLocation;
    protected int fragmentLocation;

    public URI(String nuri) throws MalformedURIException {
        this.uri = nuri;
        this.colonLocation = nuri.indexOf(58);
        this.fragmentLocation = URIClassifier.getFragmentLocation(nuri);
        if (this.colonLocation == -1 || this.colonLocation > this.fragmentLocation || this.colonLocation == 0) {
            throw new MalformedURIException("No scheme in URI \"" + this.uri + "\"", this.uri);
        }
    }

    public String makeRelative(URI otherURI, boolean allowDotDot) throws MalformedURIException {
        return otherURI.toString();
    }

    protected String genericMakeRelative(URI otherURI, int otherPathLoc, int pathloc, boolean allowDotDot) {
        String otherFile;
        String thisFile;
        if (otherPathLoc != pathloc || !this.uri.regionMatches(0, otherURI.uri, 0, pathloc)) {
            return otherURI.toString();
        }
        int commonPath = pathloc;
        int nextSlash = pathloc;
        while ((nextSlash = this.uri.indexOf(47, nextSlash + 1)) != -1 && nextSlash < this.fragmentLocation && this.uri.regionMatches(commonPath, otherURI.uri, commonPath, nextSlash - commonPath)) {
            commonPath = nextSlash;
        }
        StringBuffer relPath = new StringBuffer();
        nextSlash = commonPath;
        while ((nextSlash = this.uri.indexOf(47, nextSlash + 1)) != -1 && nextSlash < this.fragmentLocation) {
            if (allowDotDot) {
                relPath.append("../");
                continue;
            }
            relPath.append(otherURI.uri.substring(0, commonPath + 1));
            break;
        }
        if (relPath.length() == 0 && (thisFile = this.uri.substring(commonPath, this.fragmentLocation)).equals(otherFile = otherURI.uri.substring(commonPath, otherURI.fragmentLocation))) {
            commonPath = this.fragmentLocation - 1;
        }
        relPath.append(otherURI.uri.substring(commonPath + 1));
        return relPath.toString();
    }

    protected URI parseRelativeURI(String relstr) throws MalformedURIException {
        throw new MalformedURIException("Generic URIs do not support relative URIs", this.uri);
    }

    protected String genericParseRelativeURI(String relStr, int pathLoc) {
        String res;
        if (relStr.indexOf("#") == 0 || relStr.length() == 0) {
            return this.uri + relStr;
        }
        if (relStr.length() > 0 && relStr.charAt(0) == '/') {
            res = this.uri.substring(0, pathLoc) + relStr;
        } else {
            int relPos = 0;
            int uriPos = this.uri.lastIndexOf(47, this.fragmentLocation - 1);
            while (relStr.regionMatches(relPos, "../", 0, 3) && pathLoc < uriPos) {
                relPos += 3;
                uriPos = this.uri.lastIndexOf(47, uriPos - 1);
            }
            res = this.uri.substring(0, uriPos + 1) + relStr.substring(relPos);
        }
        return res;
    }

    public URL getJavaURL() throws MalformedURLException {
        return new URL(this.uri);
    }

    public String getScheme() {
        return this.uri.substring(0, this.colonLocation);
    }

    public String getSchemeSpecific() {
        return this.uri.substring(this.colonLocation + 1, this.fragmentLocation);
    }

    public String getFragment() {
        if (this.fragmentLocation == this.uri.length()) {
            return "";
        }
        return this.uri.substring(this.fragmentLocation + 1);
    }

    public String getBase() {
        return this.uri.substring(0, this.fragmentLocation);
    }

    public String getParentDirectory() {
        if (this.uri.endsWith("/")) {
            int lastSlash = this.uri.substring(0, this.uri.length()).lastIndexOf(47);
            return this.uri.substring(0, lastSlash + 1);
        }
        int lastSlash = this.uri.lastIndexOf(47);
        return this.uri.substring(0, lastSlash + 1);
    }

    public String toString() {
        return this.uri;
    }

    public boolean equals(Object compURI) {
        if (compURI == null) {
            return false;
        }
        if (compURI instanceof URI) {
            URI nuri = (URI)compURI;
            return nuri.uri.equals(this.uri);
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

