/*
 * Decompiled with CFR 0.152.
 */
package com.examples.with.different.packagename.concolic;

import com.examples.with.different.packagename.concolic.Tracer;
import java.net.URI;
import java.net.URISyntaxException;

public class URIClassifier {
    public static URI parseValidURI(String nuri) {
        return URIClassifier.parseValidURI(nuri, null);
    }

    public static URI parseValidURI(String nuri, String baseuri) {
        try {
            if (baseuri != null) {
                return URIClassifier.parseURI(nuri, URIClassifier.parseURI(baseuri, null));
            }
            return URIClassifier.parseURI(nuri, null);
        }
        catch (URISyntaxException e) {
            Tracer.bug("Malformed URI '" + e + "': \n" + e.getMessage());
            return null;
        }
    }

    public static URI parseURI(String nuri) throws URISyntaxException {
        return URIClassifier.parseURI(nuri, null);
    }

    public static URI parseURI(String nuri, URI baseuri) throws URISyntaxException {
        int colonLocation = nuri.indexOf(58);
        int fragmentLocation = URIClassifier.getFragmentLocation(nuri);
        if ((colonLocation == -1 || colonLocation > fragmentLocation) && baseuri == null) {
            throw new URISyntaxException("No ':' in \"" + nuri + "\" and no base URI given, so no relative URIs allowed", nuri);
        }
        String protocol = nuri.substring(0, colonLocation);
        if (protocol.equals("urn")) {
            return URIClassifier.parseURN(nuri, colonLocation, fragmentLocation);
        }
        if (protocol.equals("http")) {
            return new URI(nuri);
        }
        if (protocol.equals("file")) {
            return new URI(nuri);
        }
        if (protocol.equals("res")) {
            return new URI(nuri);
        }
        return URIClassifier.parseGeneralURI(nuri, colonLocation, fragmentLocation);
    }

    protected static URI parseURN(String nuri, int colonLocation, int fragmentLocation) throws URISyntaxException {
        int secondColonLocation = nuri.indexOf(58, colonLocation + 1);
        if (secondColonLocation == -1 || secondColonLocation > fragmentLocation || secondColonLocation == colonLocation + 1) {
            throw new URISyntaxException("No protocol part in URN \"" + nuri + "\".", nuri);
        }
        String urnprotocol = nuri.substring(colonLocation + 1, secondColonLocation);
        if (urnprotocol.equals("path")) {
            return new URI(nuri);
        }
        return URIClassifier.parseGeneralURN(nuri, colonLocation, secondColonLocation, fragmentLocation);
    }

    protected static URI parseGeneralURN(String nuri, int colonLocation, int secondColonLocation, int fragmentLocation) throws URISyntaxException {
        return URIClassifier.parseGeneralURI(nuri, colonLocation, fragmentLocation);
    }

    protected static URI parseGeneralURI(String nuri, int colonLocation, int fragmentLocation) throws URISyntaxException {
        return new URI(nuri);
    }

    protected static int getFragmentLocation(String s) {
        int fragmentLocation = s.indexOf(35);
        if (fragmentLocation == -1) {
            return s.length();
        }
        return fragmentLocation;
    }
}

