/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import org.evosuite.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PropertiesTest {
    @BeforeClass
    public static void initClass() {
        Properties.getInstance();
    }

    @After
    public void reset() {
        Properties.getInstance().resetToDefaults();
    }

    @Test
    public void testParameterThatDoesNotExist() {
        try {
            Properties.getInstance().setValue("a_parameter_that_does_not_exist", 1);
            Assert.fail();
        }
        catch (IllegalAccessException | IllegalArgumentException | Properties.NoSuchParameterException throwable) {
            // empty catch block
        }
    }

    @Test
    public void testOutOfRangeInput() throws IllegalArgumentException, IllegalAccessException, Properties.NoSuchParameterException {
        Properties.getInstance().setValue("crossover_rate", 0.6);
        try {
            Properties.getInstance().setValue("crossover_rate", 2.5);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Properties.getInstance().setValue("crossover_rate", -10.6);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidBooleanInput() throws Exception {
        boolean defaultValue = Properties.TEST_CARVING;
        boolean value = Properties.getBooleanValue((String)"test_carving");
        Assert.assertEquals((Object)defaultValue, (Object)value);
        Properties.getInstance().setValue("test_carving", !defaultValue);
        value = Properties.getBooleanValue((String)"test_carving");
        Assert.assertNotEquals((Object)defaultValue, (Object)value);
        try {
            Properties.getInstance().setValue("test_carving", "tru");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testReset() {
        String defaultValue = Properties.TARGET_CLASS;
        String aString = "foo_foo_foo";
        Assert.assertNotEquals((Object)defaultValue, (Object)"foo_foo_foo");
        Properties.TARGET_CLASS = "foo_foo_foo";
        Assert.assertEquals((Object)"foo_foo_foo", (Object)Properties.TARGET_CLASS);
        Properties.getInstance().resetToDefaults();
        Assert.assertEquals((Object)defaultValue, (Object)Properties.TARGET_CLASS);
    }
}

