/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import org.evosuite.instrumentation.RegexDistance;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestRegexInstantiation {
    @Test
    public void testFailingSeedingRegex() {
        String FAILING_PATTERN = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        String matchingInstance = RegexDistance.getRegexInstance((String)FAILING_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)FAILING_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(FAILING_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(FAILING_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)FAILING_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)FAILING_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEmailRegex() {
        String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        String matchingInstance = RegexDistance.getRegexInstance((String)EMAIL_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)EMAIL_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(EMAIL_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(EMAIL_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)EMAIL_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)EMAIL_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUsernameRegex() {
        String USERNAME_PATTERN = "^[a-z0-9_-]{3,15}$";
        String matchingInstance = RegexDistance.getRegexInstance((String)USERNAME_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)USERNAME_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(USERNAME_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(USERNAME_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)USERNAME_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)USERNAME_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testPasswordRegex() {
        String PASSWORD_PATTERN = "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%]).{6,20})";
        String matchingInstance = RegexDistance.getRegexInstance((String)PASSWORD_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)PASSWORD_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(PASSWORD_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(PASSWORD_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)PASSWORD_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)PASSWORD_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHexRegex() {
        String HEX_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
        String matchingInstance = RegexDistance.getRegexInstance((String)HEX_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)HEX_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(HEX_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(HEX_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)HEX_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)HEX_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImageRegex() {
        String IMAGE_PATTERN = "[^\\s]+(\\.(?i)(jpg|png|gif|bmp))$";
        String matchingInstance = RegexDistance.getRegexInstance((String)IMAGE_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)IMAGE_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(IMAGE_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(IMAGE_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)IMAGE_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)IMAGE_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIPRegex() {
        String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
        String matchingInstance = RegexDistance.getRegexInstance((String)IPADDRESS_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)IPADDRESS_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(IPADDRESS_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(IPADDRESS_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)IPADDRESS_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)IPADDRESS_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTime12Regex() {
        String TIME12HOURS_PATTERN = "(1[012]|[1-9]):[0-5][0-9](\\s)?(?i)(am|pm)";
        String matchingInstance = RegexDistance.getRegexInstance((String)TIME12HOURS_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)TIME12HOURS_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(TIME12HOURS_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(TIME12HOURS_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)TIME12HOURS_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)TIME12HOURS_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTime24Regex() {
        String TIME24HOURS_PATTERN = "([01]?[0-9]|2[0-3]):[0-5][0-9]";
        String matchingInstance = RegexDistance.getRegexInstance((String)TIME24HOURS_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)TIME24HOURS_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(TIME24HOURS_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(TIME24HOURS_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)TIME24HOURS_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)TIME24HOURS_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDateRegex() {
        String DATE_PATTERN = "(0?[1-9]|[12][0-9]|3[01])/(0?[1-9]|1[012])/((19|20)\\d\\d)";
        String matchingInstance = RegexDistance.getRegexInstance((String)DATE_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)DATE_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(DATE_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(DATE_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)DATE_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)DATE_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHTMLRegex() {
        String HTML_TAG_PATTERN = "<(\"[^\"]*\"|'[^']*'|[^'\">])*>";
        String matchingInstance = RegexDistance.getRegexInstance((String)HTML_TAG_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)HTML_TAG_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(HTML_TAG_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(HTML_TAG_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)HTML_TAG_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)HTML_TAG_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHTMLARegex() {
        String HTML_A_TAG_PATTERN = "(?i)<a([^>]+)>(.+?)</a>";
        String matchingInstance = RegexDistance.getRegexInstance((String)HTML_A_TAG_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)HTML_A_TAG_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(HTML_A_TAG_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(HTML_A_TAG_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)HTML_A_TAG_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)HTML_A_TAG_PATTERN) > 0 ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testHTMLHrefRegex() {
        String HTML_A_HREF_TAG_PATTERN = "\\s*(?i)href\\s*=\\s*\".*\"";
        String matchingInstance = RegexDistance.getRegexInstance((String)HTML_A_HREF_TAG_PATTERN);
        String nonMatchingInstance = RegexDistance.getNonMatchingRegexInstance((String)HTML_A_HREF_TAG_PATTERN);
        Assert.assertTrue((String)("String does not match regex: " + matchingInstance), (boolean)matchingInstance.matches(HTML_A_HREF_TAG_PATTERN));
        Assert.assertFalse((String)("String matches regex but shouldn't: " + nonMatchingInstance), (boolean)nonMatchingInstance.matches(HTML_A_HREF_TAG_PATTERN));
        Assert.assertTrue((RegexDistance.getDistance((String)matchingInstance, (String)HTML_A_HREF_TAG_PATTERN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((RegexDistance.getDistance((String)nonMatchingInstance, (String)HTML_A_HREF_TAG_PATTERN) > 0 ? 1 : 0) != 0);
    }
}

