/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.Assert;
import org.evosuite.Properties;
import org.evosuite.instrumentation.testability.TestabilityTransformationClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestUtil.class);

    public static void assertCorrectStart(Class<?> clazz) {
        String projectPrefix = clazz.getPackage().getName();
        Assert.assertEquals((String)("Must start test with '-DDPROJECT_PREFIX=" + projectPrefix + "'."), (String)Properties.PROJECT_PREFIX, (String)projectPrefix);
        String targetClass = clazz.getName();
        Assert.assertEquals((String)("Must start test with '-DTARGET_CLASS=" + targetClass + "'."), (String)Properties.TARGET_CLASS, (String)targetClass);
    }

    public static void assertCorrectStart(String clazz) {
        String projectPrefix = clazz.substring(0, clazz.lastIndexOf("."));
        Assert.assertEquals((String)("Must start test with '-DDPROJECT_PREFIX=" + projectPrefix + "'."), (String)Properties.PROJECT_PREFIX, (String)projectPrefix);
        String targetClass = clazz;
        Assert.assertEquals((String)("Must start test with '-DTARGET_CLASS=" + targetClass + "'."), (String)Properties.TARGET_CLASS, (String)targetClass);
    }

    public static String getPrefix(String fullyQualifiedClass) {
        return fullyQualifiedClass.substring(0, fullyQualifiedClass.lastIndexOf("."));
    }

    public static Object invokeMethod(Class<?> targetClass, Object target, String methodName, Class<?>[] argClasses, Object[] args) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, argClasses);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception exc) {
            logger.error("Encountered exception when calling method:", (Throwable)exc);
            throw new RuntimeException(exc);
        }
    }

    public static Object invokeMethod(Object target, String methodName, Object ... args) {
        return TestUtil.invokeMethod(target.getClass(), target, methodName, TestUtil.getArgClasses(args), args);
    }

    public static Object loadInstrumented(String className, Object ... constructorArgs) {
        try {
            Properties.TARGET_CLASS = className;
            Properties.TARGET_CLASS_PREFIX = Properties.PROJECT_PREFIX = TestUtil.getPrefix(className);
            TestabilityTransformationClassLoader classLoader = new TestabilityTransformationClassLoader();
            Class<?> factsComparatorClass = classLoader.loadClass(className);
            Class<?>[] argClasses = TestUtil.getArgClasses(constructorArgs);
            Constructor<?> factsComparatorConstructor = factsComparatorClass.getConstructor(argClasses);
            Object target = factsComparatorConstructor.newInstance(constructorArgs);
            return target;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void setField(Object target, String fieldName, Object value) {
        try {
            Class<?> clazz = target.getClass();
            Field field = clazz.getField(fieldName);
            field.set(target, value);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private static Class<?>[] getArgClasses(Object ... args) {
        Class[] argClasses = new Class[args.length];
        for (int idx = 0; idx < args.length; ++idx) {
            argClasses[idx] = args[idx].getClass();
        }
        return argClasses;
    }

    private TestUtil() {
    }
}

