/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion.stable;

import junit.framework.TestCase;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.junit.Assert;
import org.junit.Test;

public class TestComparisonAssertion {
    @Test
    public void testInt() {
        int x = 42;
        int y = 42;
        int z = 43;
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testIntWrapper() {
        Integer x = new Integer(42);
        Integer y = new Integer(42);
        Integer z = new Integer(43);
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testFloat() {
        float x = 42.0f;
        float y = 42.0f;
        float z = 43.0f;
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)Float.valueOf(x), (Object)Float.valueOf(z)));
    }

    @Test
    public void testFloatEpsilon() {
        float x = 42.002f;
        float y = 42.001f;
        float z = 42.1f;
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)Float.valueOf(x), (Object)Float.valueOf(y)));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)Float.valueOf(x), (Object)Float.valueOf(z)));
    }

    @Test
    public void testFloatWrapper() {
        Float x = new Float(42.0f);
        Float y = new Float(42.0f);
        Float z = new Float(43.0f);
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testDouble() {
        double x = 42.0;
        double y = 42.0;
        double z = 43.0;
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testDoubleNaN() {
        double x = Double.NaN;
        double y = Double.NaN;
        double z = 43.0;
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testDoubleEpsilon() {
        double x = 42.0001;
        double y = 42.0002;
        double z = 42.1;
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testDoubleWrapper() {
        Double x = new Double(42.0);
        Double y = new Double(42.0);
        Double z = new Double(43.0);
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }

    @Test
    public void testNonNumeric() {
        String x = "Foo";
        String y = "Foo";
        String z = "Bar";
        Assert.assertTrue((boolean)ComparisonTraceEntry.equals((Object)x, (Object)y));
        TestCase.assertFalse((boolean)ComparisonTraceEntry.equals((Object)x, (Object)z));
    }
}

