/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import com.examples.with.different.packagename.classpath.Foo;
import com.examples.with.different.packagename.classpath.subp.SubPackageFoo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.objectweb.asm.util.ASMifier;

public class ResourceListTest {
    private static final String basePrefix = "com.examples.with.different.packagename.classpath";

    @BeforeClass
    public static void initClass() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
    }

    @Before
    public void resetCache() {
        ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).resetCache();
    }

    @Test
    public void testGetPackageName() {
        Assert.assertEquals((Object)"", (Object)ResourceList.getParentPackageName((String)""));
        Assert.assertEquals((Object)"", (Object)ResourceList.getParentPackageName((String)"foo"));
        Assert.assertEquals((Object)"foo", (Object)ResourceList.getParentPackageName((String)"foo.bar"));
        Assert.assertEquals((Object)"bar.foo", (Object)ResourceList.getParentPackageName((String)"bar.foo.evo"));
    }

    @Test
    public void testStreamFromFolder() throws Exception {
        File localFolder = new File("local_test_data" + File.separator + "aCpEntry");
        Assert.assertTrue((String)("ERROR: file " + localFolder + " should be available on local file system"), (boolean)localFolder.exists());
        ClassPathHandler.getInstance().addElementToTargetProjectClassPath(localFolder.getAbsolutePath());
        String className = "foo.ExternalClass";
        InputStream stream = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className);
        Assert.assertNotNull((Object)stream);
        stream.close();
    }

    @Test
    public void testStreamFromJar() throws Exception {
        File localJar = new File("local_test_data" + File.separator + "water-simulator.jar");
        Assert.assertTrue((String)("ERROR: file " + localJar + " should be avaialable on local file system"), (boolean)localJar.exists());
        ClassPathHandler.getInstance().addElementToTargetProjectClassPath(localJar.getAbsolutePath());
        String className = "simulator.DAWN";
        InputStream stream = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className);
        Assert.assertNotNull((Object)stream);
        stream.close();
    }

    @Test
    public void testHandleUnKnownJarFile() {
        File localJar = new File("local_test_data" + File.separator + "water-simulator.jar");
        Assert.assertTrue((String)("ERROR: file " + localJar + " should be avaialable on local file system"), (boolean)localJar.exists());
        ClassPathHandler.getInstance().addElementToTargetProjectClassPath(localJar.getAbsolutePath());
        String prefix = "simulator";
        String target = prefix + ".DAWN";
        Assert.assertTrue((String)("Missing: " + target), (boolean)ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).hasClass(target));
        Set classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), prefix, false);
        Assert.assertTrue((boolean)classes.contains(target));
    }

    @Test
    public void testHandleKnownJarFile() {
        File localJar = new File("local_test_data" + File.separator + "asm-all-4.2.jar");
        Assert.assertTrue((String)("ERROR: file " + localJar + " should be avaialable on local file system"), (boolean)localJar.exists());
        ClassPathHandler.getInstance().addElementToTargetProjectClassPath(localJar.getAbsolutePath());
        String target = ASMifier.class.getName();
        String prefix = ASMifier.class.getPackage().getName();
        Assert.assertTrue((String)("Missing: " + target), (boolean)ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).hasClass(target));
        Set classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), prefix, false);
        Assert.assertTrue((boolean)classes.contains(target));
    }

    @Test
    public void testHasClass() {
        Assert.assertTrue((boolean)ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).hasClass(Foo.class.getName()));
        Assert.assertTrue((boolean)ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).hasClass(SubPackageFoo.class.getName()));
    }

    @Test
    public void testSubPackage() {
        Set classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), basePrefix, false);
        Assert.assertTrue((boolean)classes.contains(Foo.class.getName()));
        Assert.assertTrue((boolean)classes.contains(SubPackageFoo.class.getName()));
        classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), "com.examples.with.different.packagename.classpath.subp", false);
        Assert.assertTrue((!classes.contains(Foo.class.getName()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)classes.contains(SubPackageFoo.class.getName()));
    }

    @Test
    public void testGatherClassNoInternal() {
        Set classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), basePrefix, false);
        Assert.assertTrue((boolean)classes.contains(Foo.class.getName()));
        Assert.assertTrue((!classes.contains(Foo.InternalFooClass.class.getName()) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)classes.size());
    }

    @Test
    public void testGatherClassWithInternalButNoAnonymous() {
        Set classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), basePrefix, true);
        Assert.assertTrue((boolean)classes.contains(Foo.class.getName()));
        Assert.assertTrue((String)("" + Arrays.toString(classes.toArray())), (boolean)classes.contains(Foo.InternalFooClass.class.getName()));
        Assert.assertEquals((long)3L, (long)classes.size());
    }

    @Test
    public void testGatherClassWithInternalIncludingAnonymous() {
        Set classes = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), basePrefix, true, false);
        Assert.assertTrue((boolean)classes.contains(Foo.class.getName()));
        Assert.assertTrue((String)("" + Arrays.toString(classes.toArray())), (boolean)classes.contains(Foo.InternalFooClass.class.getName()));
        Assert.assertEquals((long)4L, (long)classes.size());
    }

    @Test
    public void testLoadOfEvoSuiteTestClassesAsStream() throws IOException {
        String className = ResourceListFoo.class.getName();
        InputStream res = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className);
        Assert.assertNotNull((Object)res);
        res.close();
    }

    private class ResourceListFoo {
        private ResourceListFoo() {
        }
    }
}

