/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.clinit;

import com.examples.with.different.packagename.clinit.SimpleClass;
import java.lang.reflect.Method;
import java.util.Collections;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.Assert;
import org.junit.Test;

public class TestClassInitialization {
    private static DefaultTestCase buildLoadTargetClassTestCase(String className) throws EvosuiteError {
        DefaultTestCase test = new DefaultTestCase();
        StringPrimitiveStatement stmt0 = new StringPrimitiveStatement((TestCase)test, className);
        VariableReference string0 = test.addStatement((Statement)stmt0);
        try {
            Method currentThreadMethod = Thread.class.getMethod("currentThread", new Class[0]);
            MethodStatement currentThreadStmt = new MethodStatement((TestCase)test, new GenericMethod(currentThreadMethod, currentThreadMethod.getDeclaringClass()), null, Collections.emptyList());
            VariableReference currentThreadVar = test.addStatement((Statement)currentThreadStmt);
            Method getContextClassLoaderMethod = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            MethodStatement getContextClassLoaderStmt = new MethodStatement((TestCase)test, new GenericMethod(getContextClassLoaderMethod, getContextClassLoaderMethod.getDeclaringClass()), currentThreadVar, Collections.emptyList());
            VariableReference contextClassLoaderVar = test.addStatement((Statement)getContextClassLoaderStmt);
            Method loadClassMethod = ClassLoader.class.getMethod("loadClass", String.class);
            MethodStatement loadClassStmt = new MethodStatement((TestCase)test, new GenericMethod(loadClassMethod, loadClassMethod.getDeclaringClass()), contextClassLoaderVar, Collections.singletonList(string0));
            test.addStatement((Statement)loadClassStmt);
            return test;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new EvosuiteError("Unexpected exception while creating Class Initializer Test Case");
        }
    }

    @Test
    public void checksClassIsLoadedUsingInstrumentingClassLoader() throws ClassNotFoundException {
        Properties.CLIENT_ON_THREAD = true;
        String className = SimpleClass.class.getCanonicalName();
        TestCaseExecutor.initExecutor();
        TestGenerationContext.getInstance().resetContext();
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        InstrumentingClassLoader classLoader = TestGenerationContext.getInstance().getClassLoaderForSUT();
        Assert.assertFalse((boolean)classLoader.getLoadedClasses().contains(className));
        DefaultTestCase test = TestClassInitialization.buildLoadTargetClassTestCase(className);
        TestCaseExecutor.getInstance().execute((TestCase)test, Integer.MAX_VALUE);
        Assert.assertTrue((boolean)classLoader.getLoadedClasses().contains(className));
    }
}

