/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.utils.Randomness;

public class DummyChromosome
extends Chromosome {
    private List<Integer> values = new ArrayList<Integer>();

    public DummyChromosome(int ... values) {
        for (int x : values) {
            this.values.add(x);
        }
    }

    public DummyChromosome(Collection<Integer> values) {
        this.values.addAll(values);
    }

    public DummyChromosome(DummyChromosome other) {
        this.values.addAll(other.values);
    }

    public Chromosome clone() {
        return new DummyChromosome(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DummyChromosome that = (DummyChromosome)((Object)o);
        return this.values != null ? this.values.equals(that.values) : that.values == null;
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }

    public <T extends Chromosome> int compareSecondaryObjective(T o) {
        return 0;
    }

    public void mutate() {
        if (this.values.isEmpty()) {
            return;
        }
        double P = 1.0 / (double)this.values.size();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!(Randomness.nextDouble() < P)) continue;
            this.values.set(i, Randomness.nextInt());
        }
        this.increaseNumberOfMutations();
        this.setChanged(true);
    }

    public int get(int position) {
        return this.values.get(position);
    }

    public List<Integer> getGenes() {
        return this.values;
    }

    public void crossOver(Chromosome other, int position1, int position2) throws ConstructionFailedException {
        DummyChromosome chromosome = (DummyChromosome)other;
        while (this.values.size() > position1) {
            this.values.remove(position1);
        }
        for (int num = position2; num < other.size(); ++num) {
            this.values.add(chromosome.get(num));
        }
        this.setChanged(true);
    }

    public boolean localSearch(LocalSearchObjective<? extends Chromosome> objective) {
        return false;
    }

    public int size() {
        return this.values.size();
    }
}

