/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import org.evosuite.Properties;
import org.evosuite.ga.metaheuristics.MonotonicGA;
import org.junit.Assert;
import org.junit.Test;

public class TestUpdateLocalSearchProbability {
    private static final double DELTA = 1.0E-10;

    @Test
    public void testNoChanges() {
        Properties.LOCAL_SEARCH_PROBABILITY = 0.5;
        Properties.LOCAL_SEARCH_ADAPTATION_RATE = 2.0;
        MonotonicGA ga = new MonotonicGA(null);
        Assert.assertEquals((double)0.5, (double)ga.localSearchProbability, (double)1.0E-10);
    }

    @Test
    public void testDecrease() {
        Properties.LOCAL_SEARCH_PROBABILITY = 1.0;
        Properties.LOCAL_SEARCH_ADAPTATION_RATE = 2.0;
        MonotonicGA ga = new MonotonicGA(null);
        Assert.assertEquals((double)1.0, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.5, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.25, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.125, (double)ga.localSearchProbability, (double)1.0E-10);
    }

    @Test
    public void testIncrease() {
        Properties.LOCAL_SEARCH_PROBABILITY = 0.125;
        Properties.LOCAL_SEARCH_ADAPTATION_RATE = 4.0;
        MonotonicGA ga = new MonotonicGA(null);
        Assert.assertEquals((double)0.125, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(true);
        Assert.assertEquals((double)0.5, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(true);
        Assert.assertEquals((double)1.0, (double)ga.localSearchProbability, (double)1.0E-10);
    }

    @Test
    public void testIncreaseAndDecrease() {
        Properties.LOCAL_SEARCH_PROBABILITY = 0.5;
        Properties.LOCAL_SEARCH_ADAPTATION_RATE = 2.0;
        MonotonicGA ga = new MonotonicGA(null);
        Assert.assertEquals((double)0.5, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(true);
        Assert.assertEquals((double)1.0, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(true);
        Assert.assertEquals((double)1.0, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(true);
        Assert.assertEquals((double)1.0, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.5, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.25, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.125, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.0625, (double)ga.localSearchProbability, (double)1.0E-10);
        ga.updateProbability(false);
        Assert.assertEquals((double)0.03125, (double)ga.localSearchProbability, (double)1.0E-10);
    }
}

