/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.ArrayList;
import java.util.Collection;
import org.evosuite.instrumentation.error.ErrorConditionChecker;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFloatUnderflow {
    private float x;
    private float y;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[] values = new Object[]{Float.valueOf(-3.4028235E38f), Float.valueOf(-1.7014117E38f), 0, Float.valueOf(1.7014117E38f), Float.valueOf(Float.MAX_VALUE)};
        ArrayList<Object[]> valuePairs = new ArrayList<Object[]>();
        for (Object val1 : values) {
            for (Object val2 : values) {
                valuePairs.add(new Object[]{val1, val2});
            }
        }
        return valuePairs;
    }

    public TestFloatUnderflow(float x, float y) {
        this.x = x;
        this.y = y;
    }

    private void assertUnderflow(double doubleResult, int distance, float floatResult) {
        if (doubleResult < -3.4028234663852886E38) {
            Assert.assertTrue((String)("Expected negative value for " + this.x + " and " + this.y + ": " + distance), (distance < 0 ? 1 : 0) != 0);
            Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)floatResult, (float)0.0f);
        } else {
            Assert.assertTrue((String)("Expected positive value for " + this.x + " and " + this.y + ": " + distance), (distance >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddUnderflow() {
        int result = ErrorConditionChecker.underflowDistance((float)this.x, (float)this.y, (int)98);
        this.assertUnderflow((double)this.x + (double)this.y, result, this.x + this.y);
    }

    @Test
    public void testSubUnderflow() {
        int result = ErrorConditionChecker.underflowDistance((float)this.x, (float)this.y, (int)102);
        this.assertUnderflow((double)this.x - (double)this.y, result, this.x - this.y);
    }

    @Test
    public void testMulUnderflow() {
        int result = ErrorConditionChecker.underflowDistance((float)this.x, (float)this.y, (int)106);
        this.assertUnderflow((double)this.x * (double)this.y, result, this.x * this.y);
    }

    @Test
    public void testDivUnderflow() {
        Assume.assumeTrue((this.y != 0.0f ? 1 : 0) != 0);
        int result = ErrorConditionChecker.underflowDistance((float)this.x, (float)this.y, (int)110);
        this.assertUnderflow((double)this.x / (double)this.y, result, this.x / this.y);
    }
}

