/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import org.evosuite.instrumentation.testability.BooleanHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BooleanHelperTest {
    @Before
    public void setUp() {
        BooleanHelper.clearStack();
    }

    @Test
    public void test1() {
        int distance = BooleanHelper.getDistance((int)-1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)-1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test2() {
        int distance = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)1, (int)1);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test3() {
        int distance = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)-1, (int)1);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test4() {
        int distance = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)-1, (int)1);
        BooleanHelper.pushPredicate((int)1, (int)1);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        Assert.assertTrue((distance <= 0 ? 1 : 0) != 0);
        distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distance > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test5() {
        int distanceFalse1 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue1 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        BooleanHelper.pushPredicate((int)-1, (int)1);
        int distanceFalse2 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue2 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distanceFalse1 < distanceFalse2 ? 1 : 0) != 0);
        Assert.assertTrue((distanceTrue2 < distanceTrue1 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)1, (int)1);
        int distanceFalse3 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue3 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((String)("Distances: " + distanceFalse2 + "/" + distanceFalse3), (distanceFalse2 == distanceFalse3 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Distances: " + distanceTrue2 + "/" + distanceTrue3), (distanceTrue2 == distanceTrue3 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)-100, (int)1);
        int distanceFalse4 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue4 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distanceFalse4 < distanceFalse3 ? 1 : 0) != 0);
        Assert.assertTrue((distanceTrue4 > distanceTrue3 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)100, (int)1);
        int distanceFalse5 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue5 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((distanceFalse5 == distanceFalse4 ? 1 : 0) != 0);
        Assert.assertTrue((distanceTrue5 == distanceTrue4 ? 1 : 0) != 0);
    }

    @Test
    public void test6() {
        BooleanHelper.pushPredicate((int)-1, (int)1);
        int distanceFalse2 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue2 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        int distanceFalse3 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue3 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((String)("Distances: " + distanceFalse2 + "/" + distanceFalse3), (distanceFalse2 == distanceFalse3 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Distances: " + distanceTrue2 + "/" + distanceTrue3), (distanceTrue2 == distanceTrue3 ? 1 : 0) != 0);
        BooleanHelper.pushPredicate((int)1, (int)1);
        int distanceFalse4 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue4 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((String)("Distances: " + distanceFalse4 + "/" + distanceFalse3), (distanceFalse4 == distanceFalse3 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Distances: " + distanceTrue4 + "/" + distanceTrue3), (distanceTrue4 == distanceTrue3 ? 1 : 0) != 0);
    }

    @Test
    public void test7() {
        BooleanHelper.pushPredicate((int)1, (int)1);
        int lastDistance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((lastDistance > 0 ? 1 : 0) != 0);
        for (int i = 2; i < 10; ++i) {
            BooleanHelper.pushPredicate((int)i, (int)1);
            int distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
            Assert.assertTrue((String)("Iteration " + i + ": Expecting " + distance + " > " + lastDistance), (distance > lastDistance ? 1 : 0) != 0);
            lastDistance = distance;
        }
    }

    @Test
    public void test8() {
        BooleanHelper.pushPredicate((int)1, (int)1);
        int lastDistance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((lastDistance > 0 ? 1 : 0) != 0);
        for (int i = 10; i < 100000; i += 100) {
            BooleanHelper.pushPredicate((int)i, (int)1);
            int distance = BooleanHelper.getDistance((int)1, (int)1, (int)1);
            Assert.assertTrue((String)("Iteration " + i + ": Expecting " + distance + " > " + lastDistance), (distance > lastDistance ? 1 : 0) != 0);
            lastDistance = distance;
        }
    }

    @Test
    public void test9() {
        BooleanHelper.pushPredicate((int)1, (int)1);
        int distanceFalse1 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue1 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        int distanceFalse2 = BooleanHelper.getDistance((int)1, (int)2, (int)0);
        int distanceTrue2 = BooleanHelper.getDistance((int)1, (int)2, (int)1);
        Assert.assertTrue((String)("Distances: " + distanceFalse1 + "/" + distanceFalse2), (distanceFalse1 < distanceFalse2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Distances: " + distanceTrue1 + "/" + distanceTrue2), (distanceTrue1 > distanceTrue2 ? 1 : 0) != 0);
    }

    @Test
    public void test10() {
        BooleanHelper.pushPredicate((int)34227, (int)1);
        int distanceFalse1 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue1 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        BooleanHelper.pushPredicate((int)35608, (int)1);
        int distanceFalse2 = BooleanHelper.getDistance((int)1, (int)1, (int)0);
        int distanceTrue2 = BooleanHelper.getDistance((int)1, (int)1, (int)1);
        Assert.assertTrue((String)("Distances: " + distanceFalse1 + "/" + distanceFalse2), (distanceFalse1 > distanceFalse2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Distances: " + distanceTrue1 + "/" + distanceTrue2), (distanceTrue1 < distanceTrue2 ? 1 : 0) != 0);
    }
}

