/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.evosuite.instrumentation.testability.ContainerHelper;
import org.junit.Assert;
import org.junit.Test;

public class ContainerHelpTest {
    @Test
    public void testContainsTransformation() {
        HashSet<Integer> firstSet = new HashSet<Integer>();
        firstSet.add(17);
        firstSet.add(626);
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(firstSet, (Object)17));
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(firstSet, (Object)626));
        Assert.assertTrue((ContainerHelper.collectionContains(firstSet, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsTransformationList() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(17);
        list.add(626);
        list.add(17);
        Assert.assertEquals((long)2L, (long)ContainerHelper.collectionContains(list, (Object)17));
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(list, (Object)626));
        Assert.assertTrue((ContainerHelper.collectionContains(list, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsStringTransformation() {
        HashSet<String> firstSet = new HashSet<String>();
        firstSet.add("foo");
        firstSet.add("bar");
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(firstSet, (Object)"foo"));
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(firstSet, (Object)"bar"));
        Assert.assertTrue((ContainerHelper.collectionContains(firstSet, (Object)"zoo") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsStringTransformationList() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("foo");
        list.add("bar");
        list.add("foo");
        Assert.assertEquals((long)2L, (long)ContainerHelper.collectionContains(list, (Object)"foo"));
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(list, (Object)"bar"));
        Assert.assertTrue((ContainerHelper.collectionContains(list, (Object)"zoo") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsAllTransformation() {
        HashSet<Integer> firstSet = new HashSet<Integer>();
        firstSet.add(17);
        firstSet.add(626);
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(firstSet, (Object)17));
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(firstSet, (Object)626));
        Assert.assertTrue((ContainerHelper.collectionContains(firstSet, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContainsAllTransformationList() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        list.add(17);
        list.add(626);
        list.add(17);
        Assert.assertEquals((long)2L, (long)ContainerHelper.collectionContains(list, (Object)17));
        Assert.assertEquals((long)1L, (long)ContainerHelper.collectionContains(list, (Object)626));
        Assert.assertTrue((ContainerHelper.collectionContains(list, (Object)100) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCollectionEmptyTransformation2() {
        HashSet<Integer> firstSet = new HashSet<Integer>();
        firstSet.add(17);
        firstSet.add(626);
        Assert.assertEquals((long)-2L, (long)ContainerHelper.collectionIsEmpty(firstSet));
    }

    @Test
    public void testCollectionEmptyTransformation1() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("test");
        Assert.assertEquals((long)-1L, (long)ContainerHelper.collectionIsEmpty(list));
    }

    @Test
    public void testCollectionEmptyTransformation0() {
        HashSet firstSet = new HashSet();
        Assert.assertEquals((long)0x7FFFFFFDL, (long)ContainerHelper.collectionIsEmpty(firstSet));
    }

    @Test
    public void testMapContainsKeyTransformation() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(17, 235235);
        map.put(23, 233);
        Assert.assertEquals((long)1L, (long)ContainerHelper.mapContainsKey(map, (Object)17));
        Assert.assertEquals((long)1L, (long)ContainerHelper.mapContainsKey(map, (Object)23));
        Assert.assertTrue((ContainerHelper.mapContainsKey(map, (Object)24) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMapContainsValueTransformation() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(17, 235235);
        map.put(23, 233);
        Assert.assertEquals((long)1L, (long)ContainerHelper.mapContainsValue(map, (Object)235235));
        Assert.assertEquals((long)1L, (long)ContainerHelper.mapContainsValue(map, (Object)233));
        Assert.assertTrue((ContainerHelper.mapContainsValue(map, (Object)24) < 0 ? 1 : 0) != 0);
    }
}

