/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import org.evosuite.instrumentation.testability.StringHelper;
import org.junit.Assert;
import org.junit.Test;

public class StringHelperTest {
    @Test
    public void testEquals() {
        String str1 = "test";
        String str2 = "test";
        int result = StringHelper.StringEquals((String)str1, (Object)str2);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNull() {
        String str1 = "test";
        Object str2 = null;
        int result = StringHelper.StringEquals((String)str1, str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testEqualsNullCallee() {
        String str1 = null;
        String str2 = "test";
        StringHelper.StringEquals(str1, (Object)str2);
    }

    @Test
    public void testNotEquals() {
        String str1 = "test1";
        String str2 = "test2";
        int result = StringHelper.StringEquals((String)str1, (Object)str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsRelativeOrdering() {
        String str1 = "test1";
        String str2 = "test2";
        String str3 = "something else";
        int result1 = StringHelper.StringEquals((String)str1, (Object)str2);
        int result2 = StringHelper.StringEquals((String)str1, (Object)str3);
        Assert.assertTrue((result2 < result1 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsIgnoreCase() {
        String str1 = "test";
        String str2 = "TEST";
        int result = StringHelper.StringEqualsIgnoreCase((String)str1, (String)str2);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsIgnoreCaseNull() {
        String str1 = "test";
        String str2 = null;
        int result = StringHelper.StringEqualsIgnoreCase((String)str1, str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void testEqualsIgnoreCaseNullCallee() {
        String str1 = null;
        String str2 = "test";
        StringHelper.StringEqualsIgnoreCase(str1, (String)str2);
    }

    @Test
    public void testNotEqualsIgnoreCase() {
        String str1 = "test1";
        String str2 = "test2";
        int result = StringHelper.StringEqualsIgnoreCase((String)str1, (String)str2);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsIgnoreCaseRelativeOrdering() {
        String str1 = "test1";
        String str2 = "test2";
        String str3 = "something else";
        int result1 = StringHelper.StringEqualsIgnoreCase((String)str1, (String)str2);
        int result2 = StringHelper.StringEqualsIgnoreCase((String)str1, (String)str3);
        Assert.assertTrue((result2 < result1 ? 1 : 0) != 0);
    }

    @Test
    public void testStartsWithAtStart() {
        String str = "testchen";
        String prefix = "test";
        int result = StringHelper.StringStartsWith((String)str, (String)prefix, (int)0);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStartsWith() {
        String str = "blahtestchen";
        String prefix = "test";
        int result = StringHelper.StringStartsWith((String)str, (String)prefix, (int)4);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotStartsWithAtStart() {
        String str = "testchen";
        String prefix = "foo";
        int result = StringHelper.StringStartsWith((String)str, (String)prefix, (int)0);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotStartsWith() {
        String str = "blahtestchen";
        String prefix = "foo";
        int result = StringHelper.StringStartsWith((String)str, (String)prefix, (int)4);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEndsWith() {
        String str = "foo bar test";
        String suffix = "test";
        int result = StringHelper.StringEndsWith((String)str, (String)suffix);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotEndsWith() {
        String str = "blahtestchen";
        String suffix = "foo";
        int result = StringHelper.StringEndsWith((String)str, (String)suffix);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEmpty() {
        String str = "";
        int result = StringHelper.StringIsEmpty((String)str);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotEmpty() {
        String str = "blahtestchen";
        int result = StringHelper.StringIsEmpty((String)str);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMatches() {
        String str = "hahafoo";
        String regex = ".*foo";
        int result = StringHelper.StringMatches((String)str, (String)regex);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotMatches() {
        String str = "";
        String regex = "foo";
        int result = StringHelper.StringMatches((String)str, (String)regex);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionMatches() {
        String str = "hahafoobar";
        String match = "foog";
        int result = StringHelper.StringRegionMatches((String)str, (int)4, (String)match, (int)0, (int)3);
        Assert.assertTrue((boolean)str.regionMatches(4, match, 0, 3));
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionMatches2() {
        this.checkRegionMatches("i", true, 0, "I", 0, 1);
        this.checkRegionMatches("I", true, 0, "i", 0, 1);
        this.checkRegionMatches("\u03c2", true, 0, "\u03c3", 0, 1);
    }

    private void checkRegionMatches(String str, boolean ignoreCase, int thisStart, String match, int otherStart, int len) {
        int result = StringHelper.StringRegionMatches((String)str, (boolean)ignoreCase, (int)thisStart, (String)match, (int)otherStart, (int)len);
        boolean expectedResult = str.regionMatches(ignoreCase, thisStart, match, otherStart, len);
        Assert.assertEquals((Object)expectedResult, (Object)(result > 0 ? 1 : 0));
    }

    @Test
    public void testNotRegionMatchesStart1() {
        String str = "hahafoobar";
        String match = "foog";
        int result = StringHelper.StringRegionMatches((String)str, (int)5, (String)match, (int)0, (int)3);
        Assert.assertFalse((boolean)str.regionMatches(5, match, 0, 3));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesStart2() {
        String str = "hahafoobar";
        String match = "foog";
        int result = StringHelper.StringRegionMatches((String)str, (int)4, (String)match, (int)1, (int)3);
        Assert.assertFalse((boolean)str.regionMatches(4, match, 1, 3));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesLength() {
        String str = "hahafoobar";
        String match = "foo";
        int result = StringHelper.StringRegionMatches((String)str, (int)5, (String)match, (int)0, (int)4);
        Assert.assertFalse((boolean)str.regionMatches(5, match, 0, 4));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotRegionMatchesString() {
        String str = "hahafoobar";
        String match = "bar";
        int result = StringHelper.StringRegionMatches((String)str, (int)5, (String)match, (int)0, (int)3);
        Assert.assertFalse((boolean)str.regionMatches(5, match, 0, 3));
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStringEquals() {
        int dist = StringHelper.StringEquals((String)"foo", (Object)"foo");
        Assert.assertTrue((String)("Distance should be positive, but obtained " + dist), (dist > 0 ? 1 : 0) != 0);
        int nullDist = StringHelper.StringEquals((String)"foo", null);
        Assert.assertTrue((String)("Distance should be negative, but obtained " + nullDist), (nullDist <= 0 ? 1 : 0) != 0);
        int emptyDist = StringHelper.StringEquals((String)"foo", (Object)"");
        Assert.assertTrue((String)("Distance should be negative, but obtained " + emptyDist), (emptyDist <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Empty string should be closer than null", (nullDist < emptyDist ? 1 : 0) != 0);
        try {
            dist = StringHelper.StringEquals(null, (Object)"foo");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int closer = StringHelper.StringEquals((String)"foo1", (Object)"foo2");
        int larger = StringHelper.StringEquals((String)"xyz", (Object)"foo");
        Assert.assertTrue((String)("Invalid distances " + closer + " and " + larger), (closer > larger && closer <= 0 ? 1 : 0) != 0);
        dist = StringHelper.StringEquals((String)" foo", (Object)"foo ");
        Assert.assertTrue((String)("Distance should be negative, but obtained " + dist), (dist <= 0 ? 1 : 0) != 0);
        int first = StringHelper.StringEquals((String)"foo123", (Object)"foo");
        int last = StringHelper.StringEquals((String)"foo123", (Object)"123");
        Assert.assertTrue((String)("Invalid distances " + first + " and " + last), (first >= last && first <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStringEquals2() {
        double dist = StringHelper.StringEqualsCharacterDistance((String)"foo", (Object)"foo");
        Assert.assertTrue((String)("Distance should be positive, but obtained " + dist), (dist > 0.0 ? 1 : 0) != 0);
        double nullDist = StringHelper.StringEqualsCharacterDistance((String)"foo", null);
        Assert.assertTrue((String)("Distance should be negative, but obtained " + nullDist), (nullDist <= 0.0 ? 1 : 0) != 0);
        double emptyDist = StringHelper.StringEqualsCharacterDistance((String)"foo", (Object)"");
        Assert.assertTrue((String)("Distance should be negative, but obtained " + emptyDist), (emptyDist <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Empty string should be closer than null", (nullDist < emptyDist ? 1 : 0) != 0);
        try {
            dist = StringHelper.StringEqualsCharacterDistance(null, (Object)"foo");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        double closer = StringHelper.StringEqualsCharacterDistance((String)"foo1", (Object)"foo2");
        double larger = StringHelper.StringEqualsCharacterDistance((String)"xyz", (Object)"foo");
        Assert.assertTrue((String)("Invalid distances " + closer + " and " + larger), (closer > larger && closer <= 0.0 ? 1 : 0) != 0);
        closer = StringHelper.StringEqualsCharacterDistance((String)"foo", (Object)"fop");
        larger = StringHelper.StringEqualsCharacterDistance((String)"foo", (Object)"foq");
        Assert.assertTrue((closer <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((larger <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Invalid distances " + closer + " and " + larger), (closer > larger ? 1 : 0) != 0);
        dist = StringHelper.StringEqualsCharacterDistance((String)" foo", (Object)"foo ");
        Assert.assertTrue((String)("Distance should be negative, but obtained " + dist), (dist <= 0.0 ? 1 : 0) != 0);
        double first = StringHelper.StringEqualsCharacterDistance((String)"foo123", (Object)"foo");
        double last = StringHelper.StringEqualsCharacterDistance((String)"foo123", (Object)"123");
        Assert.assertTrue((String)("Invalid distances " + first + " and " + last), (first >= last && first <= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testCharacterDistanceUsed() {
        String str1 = "test1";
        String str2 = "test2";
        String str4 = "test4";
        int result1 = StringHelper.StringEquals((String)"test3", (Object)str1);
        int result2 = StringHelper.StringEquals((String)"test3", (Object)str2);
        int result4 = StringHelper.StringEquals((String)"test3", (Object)str4);
        Assert.assertTrue((result1 < result2 ? 1 : 0) != 0);
        Assert.assertTrue((result2 == result4 ? 1 : 0) != 0);
        Assert.assertTrue((result1 < result4 ? 1 : 0) != 0);
    }
}

