/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import org.evosuite.instrumentation.testability.BooleanHelper;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.numeric.DoublePrimitiveStatement;
import org.junit.Assert;
import org.junit.Test;

public class TestDoubleFloatComparison {
    @Test
    public void testDoubleComparison() {
        int x = BooleanHelper.doubleSubG((double)0.0, (double)0.0);
        int y = BooleanHelper.doubleSubG((double)10.0, (double)0.0);
        Assert.assertTrue((y > x ? 1 : 0) != 0);
        int z = BooleanHelper.doubleSubG((double)20.0, (double)0.0);
        Assert.assertTrue((z > x ? 1 : 0) != 0);
        Assert.assertTrue((z > y ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleComparison2() {
        Assert.assertEquals((Object)(Double.compare(1000.0, 1.0) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1000.0, (double)1.0) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1000.0, 1.0) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1000.0, (double)1.0) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1000.0, 1.0) == 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1000.0, (double)1.0) == 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1.0, 1000.0) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1.0, (double)1000.0) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1.0, 1000.0) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1.0, (double)1000.0) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1.0, 1000.0) == 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1.0, (double)1000.0) == 0 ? 1 : 0));
    }

    @Test
    public void testDoubleNegativeComparison() {
        int y;
        int x = BooleanHelper.doubleSubG((double)0.0, (double)0.0);
        Assert.assertTrue((x > (y = BooleanHelper.doubleSubG((double)-10.0, (double)0.0)) ? 1 : 0) != 0);
        int z = BooleanHelper.doubleSubG((double)-20.0, (double)0.0);
        Assert.assertTrue((z < x ? 1 : 0) != 0);
        Assert.assertTrue((z < y ? 1 : 0) != 0);
    }

    @Test
    public void testLargeDoubleComparison() {
        int x = BooleanHelper.doubleSubG((double)29380.0, (double)3266.3);
        int y = BooleanHelper.doubleSubG((double)2.3562985124125E7, (double)2938.2525);
        Assert.assertTrue((y > x ? 1 : 0) != 0);
        int z = BooleanHelper.doubleSubG((double)2.3862862923423E8, (double)2352.2323);
        Assert.assertTrue((z > x ? 1 : 0) != 0);
        Assert.assertTrue((z > y ? 1 : 0) != 0);
    }

    @Test
    public void testLargeDoubleNegativeComparison() {
        int x = BooleanHelper.doubleSubG((double)-29380.0, (double)3266.3);
        int y = BooleanHelper.doubleSubG((double)-2.3562985124125E7, (double)2938.2525);
        Assert.assertTrue((y < x ? 1 : 0) != 0);
        int z = BooleanHelper.doubleSubG((double)-2.3862862923423E8, (double)2352.2323);
        Assert.assertTrue((z < x ? 1 : 0) != 0);
        Assert.assertTrue((z < y ? 1 : 0) != 0);
    }

    @Test
    public void testExamples() {
        int a2;
        double x1 = -1939.9207985389992;
        double x2 = -1941.2134374492741;
        double y1 = -89.0;
        double y2 = -95.11816569743506;
        double z1 = 291.0;
        double z2 = 291.35140748465363;
        int a1 = BooleanHelper.doubleSubG((double)x1, (double)0.0);
        Assert.assertTrue((a1 > (a2 = BooleanHelper.doubleSubG((double)x2, (double)0.0)) ? 1 : 0) != 0);
        int b1 = BooleanHelper.doubleSubG((double)y1, (double)0.0);
        int b2 = BooleanHelper.doubleSubG((double)y2, (double)0.0);
        Assert.assertTrue((b1 > b2 ? 1 : 0) != 0);
        int c1 = BooleanHelper.doubleSubG((double)z1, (double)0.0);
        int c2 = BooleanHelper.doubleSubG((double)z2, (double)0.0);
        Assert.assertTrue((c1 < c2 ? 1 : 0) != 0);
    }

    @Test
    public void testDelta() {
        int i;
        double d2;
        DefaultTestCase test = new DefaultTestCase();
        DoublePrimitiveStatement statement1 = new DoublePrimitiveStatement((TestCase)test);
        DoublePrimitiveStatement statement2 = new DoublePrimitiveStatement((TestCase)test);
        double d1 = (Double)statement1.getValue();
        int val = BooleanHelper.doubleSubG((double)d1, (double)(d2 = ((Double)statement2.getValue()).doubleValue()));
        Assert.assertEquals((Object)(val > 0 ? 1 : 0), (Object)(d1 > d2 ? 1 : 0));
        Assert.assertEquals((Object)(val < 0 ? 1 : 0), (Object)(d1 < d2 ? 1 : 0));
        Assert.assertEquals((Object)(val == 0 ? 1 : 0), (Object)(d1 == d2 ? 1 : 0));
        for (i = 0; i < 100; ++i) {
            statement1.delta();
            statement2.delta();
            d1 = (Double)statement1.getValue();
            d2 = (Double)statement2.getValue();
            val = BooleanHelper.doubleSubG((double)d1, (double)d2);
            Assert.assertEquals((Object)(val > 0 ? 1 : 0), (Object)(d1 > d2 ? 1 : 0));
            Assert.assertEquals((Object)(val < 0 ? 1 : 0), (Object)(d1 < d2 ? 1 : 0));
            Assert.assertEquals((Object)(val == 0 ? 1 : 0), (Object)(d1 == d2 ? 1 : 0));
        }
        for (i = 0; i < 100; ++i) {
            statement1.randomize();
            statement2.randomize();
            d1 = (Double)statement1.getValue();
            d2 = (Double)statement2.getValue();
            val = BooleanHelper.doubleSubG((double)d1, (double)d2);
            Assert.assertEquals((Object)(val > 0 ? 1 : 0), (Object)(d1 > d2 ? 1 : 0));
            Assert.assertEquals((Object)(val < 0 ? 1 : 0), (Object)(d1 < d2 ? 1 : 0));
            Assert.assertEquals((Object)(val == 0 ? 1 : 0), (Object)(d1 == d2 ? 1 : 0));
        }
    }

    @Test
    public void testInfinityAndDouble() {
        Assert.assertTrue((BooleanHelper.doubleSubG((double)Double.POSITIVE_INFINITY, (double)0.0) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanHelper.doubleSubG((double)Double.NEGATIVE_INFINITY, (double)0.0) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanHelper.doubleSubG((double)0.0, (double)Double.POSITIVE_INFINITY) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanHelper.doubleSubG((double)0.0, (double)Double.NEGATIVE_INFINITY) != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNaNAndDouble() {
        Assert.assertEquals((long)1L, (long)BooleanHelper.doubleSubG((double)Double.NaN, (double)0.0));
        Assert.assertEquals((long)1L, (long)BooleanHelper.doubleSubG((double)0.0, (double)Double.NaN));
        Assert.assertEquals((long)-1L, (long)BooleanHelper.doubleSubL((double)Double.NaN, (double)0.0));
        Assert.assertEquals((long)-1L, (long)BooleanHelper.doubleSubL((double)0.0, (double)Double.NaN));
    }

    @Test
    public void testDoubleNaN2() {
        double p = Double.NaN;
        Assert.assertEquals((Object)(Double.compare(p, Double.NaN) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubL((double)p, (double)Double.NaN) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, Double.NaN) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)Double.NaN) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, Double.NaN) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubL((double)p, (double)Double.NaN) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, Double.NaN) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)Double.NaN) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, 0.0) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)0.0) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, 0.0) == 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)0.0) == 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, 0.0) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)0.0) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, 1.0) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)1.0) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, 1.0) == 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)1.0) == 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(p, 1.0) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)p, (double)1.0) < 0 ? 1 : 0));
        Assert.assertTrue((BooleanHelper.doubleSubG((double)0.0, (double)p) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)(Double.compare(0.0, p) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)0.0, (double)p) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(0.0, p) > 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)0.0, (double)p) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1.0, p) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubG((double)1.0, (double)p) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Double.compare(1.0, p) < 0 ? 1 : 0), (Object)(BooleanHelper.doubleSubL((double)1.0, (double)p) < 0 ? 1 : 0));
    }

    @Test
    public void testFloatNaN2() {
        float p = Float.NaN;
        Assert.assertEquals((Object)(Float.compare(p, Float.NaN) > 0 ? 1 : 0), (Object)(BooleanHelper.floatSubL((float)p, (float)Float.NaN) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, Float.NaN) > 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)Float.NaN) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, Float.NaN) < 0 ? 1 : 0), (Object)(BooleanHelper.floatSubL((float)p, (float)Float.NaN) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, Float.NaN) < 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)Float.NaN) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, 0.0f) < 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)0.0f) < 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, 0.0f) == 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)0.0f) == 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, 0.0f) > 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)0.0f) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, 1.0f) > 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)1.0f) > 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, 1.0f) == 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)1.0f) == 0 ? 1 : 0));
        Assert.assertEquals((Object)(Float.compare(p, 1.0f) < 0 ? 1 : 0), (Object)(BooleanHelper.floatSubG((float)p, (float)1.0f) < 0 ? 1 : 0));
    }

    @Test
    public void testInfinityAndFloat() {
        Assert.assertTrue((BooleanHelper.floatSubG((float)Float.POSITIVE_INFINITY, (float)0.0f) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanHelper.floatSubG((float)Float.NEGATIVE_INFINITY, (float)0.0f) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanHelper.floatSubG((float)0.0f, (float)Float.POSITIVE_INFINITY) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((BooleanHelper.floatSubG((float)0.0f, (float)Float.NEGATIVE_INFINITY) != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNaNAndFloat() {
        Assert.assertEquals((long)1L, (long)BooleanHelper.floatSubG((float)Float.NaN, (float)0.0f));
        Assert.assertEquals((long)1L, (long)BooleanHelper.floatSubG((float)0.0f, (float)Float.NaN));
        Assert.assertEquals((long)-1L, (long)BooleanHelper.floatSubL((float)Float.NaN, (float)0.0f));
        Assert.assertEquals((long)-1L, (long)BooleanHelper.floatSubL((float)0.0f, (float)Float.NaN));
    }

    @Test
    public void testRoundingErrorForSmallNumber() {
        float a = -1.4E-45f;
        Assert.assertTrue((BooleanHelper.floatSubG((float)a, (float)0.0f) < 0 ? 1 : 0) != 0);
    }
}

