/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ResourceList;
import org.evosuite.graphs.cfg.CFGClassAdapter;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestabilityTransformationClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(TestabilityTransformationClassLoader.class);
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes = new HashMap();

    public TestabilityTransformationClassLoader() {
        super(TestabilityTransformationClassLoader.class.getClassLoader());
        this.setClassAssertionStatus(Properties.TARGET_CLASS, true);
        this.classLoader = TestabilityTransformationClassLoader.class.getClassLoader();
    }

    public static boolean checkIfCanInstrument(String className) {
        for (String s : TestabilityTransformationClassLoader.getPackagesShouldNotBeInstrumented()) {
            if (!className.startsWith(s)) continue;
            return false;
        }
        return true;
    }

    public static String[] getPackagesShouldNotBeInstrumented() {
        return new String[]{"java.", "javax.", "sun.", PackageInfo.getEvoSuitePackage(), "org.exsyst", "de.unisb.cs.st.testcarver", "de.unisb.cs.st.evosuite", "org.uispec4j", "de.unisb.cs.st.specmate", "org.xml", "org.w3c", "testing.generation.evosuite", "com.yourkit", "com.vladium.emma.", "daikon.", "apple.", "com.apple.", "com.sun", "org.junit", "junit.framework", "org.apache.xerces.dom3", "de.unisl.cs.st.bugex", "corina.cross.Single"};
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!TestabilityTransformationClassLoader.checkIfCanInstrument(name)) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            result = this.classLoader.loadClass(name);
            return result;
        }
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        logger.info("Seeing class for first time: " + name);
        Class<?> instrumentedClass = null;
        instrumentedClass = this.instrumentClass(name);
        return instrumentedClass;
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        logger.info("Instrumenting class '" + fullyQualifiedTargetClass + "'.");
        try {
            String className = fullyQualifiedTargetClass.replace('.', '/');
            InputStream is = ResourceList.getInstance((ClassLoader)TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className);
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class' should be in target project, but could not be found!");
            }
            ClassReader reader = new ClassReader(is);
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 4);
            CFGClassAdapter cv = new CFGClassAdapter(this.classLoader, null, className);
            classNode.accept((ClassVisitor)cv);
            BooleanTestabilityTransformation tt = new BooleanTestabilityTransformation(classNode, (ClassLoader)this);
            try {
                classNode = tt.transform();
            }
            catch (Throwable t) {
                throw new Error(t);
            }
            ClassWriter writer = new ClassWriter(2);
            classNode.accept((ClassVisitor)writer);
            byte[] byteBuffer = writer.toByteArray();
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Keeping class: " + fullyQualifiedTargetClass);
            return result;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }
}

