/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.javaagent;

import org.evosuite.Properties;
import org.evosuite.TestUtil;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.instrumentation.testability.TestabilityTransformationClassLoader;
import org.evosuite.javaagent.ClassLoaderTestSubject;
import org.evosuite.javaagent.DependentClassLoaderTestSubject;
import org.evosuite.javaagent.InnerClassesTestSubject;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class InstrumentingClassLoaderTest {
    @BeforeClass
    public static void initClass() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
    }

    @Test
    public void testClassWithStaticInitializationCallingGetPackage() throws ClassNotFoundException {
        InstrumentingClassLoader instrumentingClassLoader = new InstrumentingClassLoader();
        Class<?> stat = Class.forName("com.examples.with.different.packagename.StatInitIssue", true, (ClassLoader)instrumentingClassLoader);
    }

    @Ignore
    @Test
    public void testDependingInstrumentation() throws Exception {
        Class<DependentClassLoaderTestSubject> originalClass = DependentClassLoaderTestSubject.class;
        Properties.TARGET_CLASS = originalClass.getName();
        Properties.TARGET_CLASS_PREFIX = Properties.PROJECT_PREFIX = originalClass.getPackage().getName();
        TestabilityTransformationClassLoader instrumentingClassLoader = new TestabilityTransformationClassLoader();
        Class<?> changedClass = instrumentingClassLoader.loadClass(ClassLoaderTestSubject.class.getName());
        Assert.assertEquals((Object)instrumentingClassLoader, (Object)changedClass.getClassLoader());
        Object changed = changedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        ExecutionTracer.enable();
        ExecutionTracer.getExecutionTracer().clear();
        TestUtil.invokeMethod(changed, "trySomethingElse", new Object[0]);
        ExecutionTrace execTrace = ExecutionTracer.getExecutionTracer().getTrace();
        execTrace = ExecutionTracer.getExecutionTracer().getTrace();
        Assert.assertFalse((boolean)execTrace.getTrueDistances().isEmpty());
        Assert.assertFalse((boolean)execTrace.getFalseDistances().isEmpty());
        ExecutionTracer.getExecutionTracer().clear();
    }

    @Ignore
    @Test
    public void testDirectInstrumentation() throws Exception {
        Class<ClassLoaderTestSubject> originalClass = ClassLoaderTestSubject.class;
        Properties.TARGET_CLASS = originalClass.getName();
        Properties.PROJECT_PREFIX = originalClass.getPackage().getName();
        ClassLoaderTestSubject original = new ClassLoaderTestSubject();
        ExecutionTracer.enable();
        ExecutionTracer.getExecutionTracer().clear();
        original.assess(6);
        ExecutionTrace execTrace = ExecutionTracer.getExecutionTracer().getTrace();
        Assert.assertTrue((boolean)execTrace.getTrueDistances().isEmpty());
        Assert.assertTrue((boolean)execTrace.getFalseDistances().isEmpty());
        TestabilityTransformationClassLoader instrumentingClassLoader = new TestabilityTransformationClassLoader();
        Class<?> changedClass = instrumentingClassLoader.loadClass(ClassLoaderTestSubject.class.getName());
        Assert.assertEquals((Object)instrumentingClassLoader, (Object)changedClass.getClassLoader());
        Assert.assertTrue((changedClass.hashCode() != originalClass.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)changedClass.equals(originalClass));
        Object changed = changedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        try {
            ClassLoaderTestSubject casted = (ClassLoaderTestSubject)changed;
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        ExecutionTracer.getExecutionTracer().clear();
        TestUtil.invokeMethod(changed, "assess", 6);
        execTrace = ExecutionTracer.getExecutionTracer().getTrace();
        Assert.assertFalse((boolean)execTrace.getTrueDistances().isEmpty());
        Assert.assertFalse((boolean)execTrace.getFalseDistances().isEmpty());
        ExecutionTracer.getExecutionTracer().clear();
    }

    @Ignore
    @Test
    public void testInnerClasses() throws Exception {
        Class<InnerClassesTestSubject> originalClass = InnerClassesTestSubject.class;
        Properties.TARGET_CLASS = originalClass.getName();
        Properties.PROJECT_PREFIX = originalClass.getPackage().getName();
        TestabilityTransformationClassLoader instrumentingClassLoader = new TestabilityTransformationClassLoader();
        Class<?> changedClass = instrumentingClassLoader.loadClass(InnerClassesTestSubject.class.getName());
        Assert.assertEquals((Object)instrumentingClassLoader, (Object)changedClass.getClassLoader());
        Assert.assertTrue((changedClass.hashCode() != originalClass.hashCode() ? 1 : 0) != 0);
        InnerClassesTestSubject original = (InnerClassesTestSubject)originalClass.newInstance();
        Assert.assertEquals((Object)"abcd", (Object)original.toString());
        Object modified = changedClass.newInstance();
        Assert.assertEquals((Object)"abcd", (Object)modified.toString());
    }
}

