/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import com.examples.with.different.packagename.junit.Foo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.evosuite.junit.JUnitResultBuilderTest;
import org.junit.Assert;
import org.junit.Test;

public class FooTestClassLoader {
    private static final String FOO_TEST_CLASS_NAME = "com.examples.with.different.packagename.junit.FooTest";

    @Test
    public void testFooTestClassCreation() throws IOException {
        Class<?> clazz = this.loadFooTestClass();
        Assert.assertNotNull(clazz);
    }

    private static String createFooTestJavaText() {
        StringBuffer buff = new StringBuffer();
        buff.append("package com.examples.with.different.packagename.junit;\n");
        buff.append("import static org.junit.Assert.assertEquals;\n");
        buff.append("import org.junit.Test;\n");
        buff.append("public class FooTest {\n");
        buff.append("\t@Test\n");
        buff.append("\tpublic void test1() {\n");
        buff.append("\t\tFoo foo = new Foo();\n");
        buff.append("\t\tint result = foo.add(10, 15);\n");
        buff.append("\t\tassertEquals(25, result);\n");
        buff.append("\t}\n");
        buff.append("\t@Test\n");
        buff.append("\tpublic void test2() {\n");
        buff.append("\t\tFoo foo = new Foo();\n");
        buff.append("\t\tint result = foo.add(20, 35);\n");
        buff.append("\t\tassertEquals(55, result);\n");
        buff.append("\t}\n");
        buff.append("\t@Test \n");
        buff.append("\tpublic void test3() {\n");
        buff.append("\t\tFoo foo = new Foo();\n");
        buff.append("\t\tint result = foo.add(10, 35);\n");
        buff.append("\t\tassertEquals(46, result);\n");
        buff.append("\t}\n");
        buff.append("}\n");
        return buff.toString();
    }

    private static File createNewTmpDir() {
        File dir = null;
        String dirName = FileUtils.getTempDirectoryPath() + File.separator + "EvoSuite_" + JUnitResultBuilderTest.class.getCanonicalName() + "_" + System.currentTimeMillis();
        dir = new File(dirName);
        if (!dir.mkdirs()) {
            return null;
        }
        if (!dir.exists()) {
            return null;
        }
        return dir;
    }

    public Class<?> loadFooTestClass() {
        File tempDir = FooTestClassLoader.createNewTmpDir();
        if (tempDir == null) {
            return null;
        }
        String javaSrcDirName = tempDir.getAbsolutePath() + File.separator + "src";
        String javaBinDirName = tempDir.getAbsolutePath() + File.separator + "bin";
        String javaSrcPackageDirName = javaSrcDirName + File.separator + "com.examples.with.different.packagename.junit".replace(".", File.separator);
        String javaBinPackageDirName = javaBinDirName + File.separator + "com.examples.with.different.packagename.junit".replace(".", File.separator);
        File javaBinDir = new File(javaBinDirName);
        if (!javaBinDir.mkdirs()) {
            return null;
        }
        File packageDir = new File(javaSrcPackageDirName);
        if (!packageDir.mkdirs()) {
            return null;
        }
        String javaFilename = javaSrcPackageDirName + File.separator + "FooTest.java";
        String classFilename = javaBinPackageDirName + File.separator + "FooTest.class";
        String javaSourceText = FooTestClassLoader.createFooTestJavaText();
        File javaFile = this.writeJavaSourceText(javaSourceText, javaFilename);
        if (javaFile == null) {
            return null;
        }
        boolean compiled = FooTestClassLoader.compileJavaFile(javaBinDirName, javaFile);
        if (!compiled) {
            return null;
        }
        File classFile = new File(classFilename);
        if (!classFile.exists()) {
            return null;
        }
        Class<?> clazz = FooTestClassLoader.loadClass(javaBinDir);
        if (clazz == null) {
            return null;
        }
        classFile.delete();
        return clazz;
    }

    private static Class<?> loadClass(File javaBinDir) {
        URLClassLoader urlClassLoader = null;
        try {
            URI javaBinURI = javaBinDir.toURI();
            URL javaBinURL = javaBinURI.toURL();
            urlClassLoader = new URLClassLoader(new URL[]{javaBinURL}, Foo.class.getClassLoader());
            Class<?> clazz = urlClassLoader.loadClass(FOO_TEST_CLASS_NAME);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static boolean compileJavaFile(String javaBinDirName, File javaFile) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            return false;
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, Locale.getDefault(), Charset.forName("UTF-8"));
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Collections.singletonList(javaFile));
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-d", javaBinDirName));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, optionList, null, compilationUnits);
        boolean compiled = task.call();
        try {
            fileManager.close();
        }
        catch (IOException e) {
            return false;
        }
        return compiled;
    }

    private File writeJavaSourceText(String javaSourceText, String javaFilename) {
        File javaFile = new File(javaFilename);
        if (javaFile.exists()) {
            return null;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(javaFilename));
            writer.write(javaSourceText);
            writer.close();
        }
        catch (IOException e) {
            return null;
        }
        return javaFile;
    }
}

