/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import com.examples.with.different.packagename.sandbox.OpenStreamInATryCatch;
import com.examples.with.different.packagename.sandbox.OpenStreamInATryCatch_FakeTestToCarve;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.factories.JUnitTestCarvedChromosomeFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JUnitAnalyzerTest {
    private static final Properties.Criterion[] defaultCriterion = Properties.CRITERION;
    private static final String defaultSelectedJUnit = Properties.SELECTED_JUNIT;
    private static final int defaultSeedMutations = Properties.SEED_MUTATIONS;
    private static final double defaultSeedClone = Properties.SEED_CLONE;
    private static final boolean DEFAULT_VFS = Properties.VIRTUAL_FS;
    private static final boolean DEFAULT_SANDBOX = Properties.SANDBOX;
    private static final boolean DEFAULT_ASSERTS_FOR_EVO = Properties.ENABLE_ASSERTS_FOR_EVOSUITE;
    private static final boolean DEFAULT_SCAFFOLDING = Properties.TEST_SCAFFOLDING;
    private File file = new File("OpenStream_foo.txt");

    @Before
    public void init() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file.deleteOnExit();
    }

    @After
    public void reset() {
        Properties.CRITERION = defaultCriterion;
        Properties.SELECTED_JUNIT = defaultSelectedJUnit;
        Properties.SEED_MUTATIONS = defaultSeedMutations;
        Properties.SEED_CLONE = defaultSeedClone;
        Properties.VIRTUAL_FS = DEFAULT_VFS;
        Properties.SANDBOX = DEFAULT_SANDBOX;
        Properties.ENABLE_ASSERTS_FOR_EVOSUITE = DEFAULT_ASSERTS_FOR_EVO;
        Properties.TEST_SCAFFOLDING = DEFAULT_SCAFFOLDING;
    }

    @Test
    public void testSandboxIssue() throws Exception {
        Properties.SELECTED_JUNIT = OpenStreamInATryCatch_FakeTestToCarve.class.getCanonicalName();
        Properties.TARGET_CLASS = OpenStreamInATryCatch.class.getCanonicalName();
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.BRANCH};
        Properties.SEED_MUTATIONS = 0;
        Properties.SEED_CLONE = 1.0;
        Properties.VIRTUAL_FS = false;
        Properties.SANDBOX = true;
        Properties.ENABLE_ASSERTS_FOR_EVOSUITE = true;
        Properties.TEST_SCAFFOLDING = false;
        Sandbox.initializeSecurityManagerForSUT();
        Assert.assertFalse((boolean)this.file.exists());
        JUnitTestCarvedChromosomeFactory factory = new JUnitTestCarvedChromosomeFactory(null);
        TestChromosome carved = factory.getChromosome();
        Files.deleteIfExists(this.file.toPath());
        Assert.assertFalse((boolean)this.file.exists());
        Assert.assertNotNull((Object)carved);
        TestCase test = carved.getTestCase();
        Assert.assertEquals((String)"Should be: constructor, 1 variable and 1 method", (long)3L, (long)test.size());
        ArrayList<TestCase> list = new ArrayList<TestCase>();
        list.add(test);
        Assert.assertFalse((boolean)this.file.exists());
        System.out.println("\n COMPILATION CHECK \n");
        JUnitAnalyzer.removeTestsThatDoNotCompile(list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)this.file.exists());
        System.out.println("\n FIRST STABILITY CHECK \n");
        JUnitAnalyzer.handleTestsThatAreUnstable(list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)this.file.exists());
        System.out.println("\n SECOND STABILITY CHECK \n");
        JUnitAnalyzer.handleTestsThatAreUnstable(list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)this.file.exists());
        System.out.println("\n FINAL VERIFICATION \n");
        JUnitAnalyzer.verifyCompilationAndExecution(list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)this.file.exists());
    }

    @Test
    public void testCreationOfTmpDir() throws IOException {
        File dir = JUnitAnalyzer.createNewTmpDir();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
        FileUtils.deleteDirectory((File)dir);
        Assert.assertFalse((boolean)dir.exists());
    }
}

