/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.naming.methods;

import com.examples.with.different.packagename.ClassWithOverloadedConstructor;
import java.util.ArrayList;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.coverage.io.input.InputCoverageGoal;
import org.evosuite.coverage.io.input.InputCoverageTestFitness;
import org.evosuite.coverage.io.output.OutputCoverageGoal;
import org.evosuite.coverage.io.output.OutputCoverageTestFitness;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.coverage.method.MethodCoverageTestFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.junit.naming.methods.CoverageGoalTestNameGenerationStrategy;
import org.evosuite.runtime.mock.java.lang.MockArithmeticException;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.objectweb.asm.Type;

public class TestCoverageGoalNameGeneration {
    @Test
    public void testUniqueMethod() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal = new MethodCoverageTestFitness("FooClass", "toString");
        test.addCoveredGoal((TestFitnessFunction)goal);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testToString", (Object)generatedName);
    }

    @Test
    public void testUniqueConstructor() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal = new MethodCoverageTestFitness("FooClass", "<init>");
        test.addCoveredGoal((TestFitnessFunction)goal);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testCreatesFooClass", (Object)generatedName);
    }

    @Test
    public void testTwoTestsUniqueMethods() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "getSomeStuff");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testGetSomeStuff", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testTwoTestsMethodsWithSharedGoals() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "getSomeStuff");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "doFooBar");
        test1.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testGetSomeStuff", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMethodWithAndWithoutException() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        MethodNoExceptionCoverageTestFitness goal1a = new MethodNoExceptionCoverageTestFitness("FooClass", "toString()");
        test1.addCoveredGoal((TestFitnessFunction)goal1a);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        ExceptionCoverageTestFitness goal2 = new ExceptionCoverageTestFitness("FooClass", "toString()", RuntimeException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToStringThrowsRuntimeException", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMethodWithAndWithoutMockException() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        MethodNoExceptionCoverageTestFitness goal1a = new MethodNoExceptionCoverageTestFitness("FooClass", "toString()");
        test1.addCoveredGoal((TestFitnessFunction)goal1a);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        ExceptionCoverageTestFitness goal2 = new ExceptionCoverageTestFitness("FooClass", "toString()", MockArithmeticException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToStringThrowsArithmeticException", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMethodWithExceptions() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "toString2()");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ExceptionCoverageTestFitness goal3 = new ExceptionCoverageTestFitness("FooClass", "toString()", MockArithmeticException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test1.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToString2", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testConstructorWithAndWithoutException() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        MethodNoExceptionCoverageTestFitness goal1a = new MethodNoExceptionCoverageTestFitness("FooClass", "<init>()");
        test1.addCoveredGoal((TestFitnessFunction)goal1a);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        ExceptionCoverageTestFitness goal2 = new ExceptionCoverageTestFitness("FooClass", "<init>()", RuntimeException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testCreatesFooClass", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFailsToCreateFooClassThrowsRuntimeException", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMethodWithOutputGoals() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString");
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "toString", this.objectType(), "Null");
        OutputCoverageTestFitness goal2 = new OutputCoverageTestFitness(outputGoal1);
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        OutputCoverageGoal outputGoal2 = new OutputCoverageGoal("FooClass", "toString", this.objectType(), "NonNull");
        OutputCoverageTestFitness goal3 = new OutputCoverageTestFitness(outputGoal2);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToStringReturningNull", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToStringReturningNonNull", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMethodWithInputGoals() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString");
        InputCoverageGoal inputGoal1 = new InputCoverageGoal("FooClass", "toString", 0, this.objectType(), "Null");
        InputCoverageTestFitness goal2 = new InputCoverageTestFitness(inputGoal1);
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        InputCoverageGoal inputGoal2 = new InputCoverageGoal("FooClass", "toString", 0, this.objectType(), "NonNull");
        InputCoverageTestFitness goal3 = new InputCoverageTestFitness(inputGoal2);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToStringWithNull", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToStringWithNonNull", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMethodWithInputOutputGoals() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString");
        InputCoverageGoal inputGoal1 = new InputCoverageGoal("FooClass", "toString", 0, this.objectType(), "Null");
        InputCoverageTestFitness goal2 = new InputCoverageTestFitness(inputGoal1);
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        OutputCoverageGoal outputGoal2 = new OutputCoverageGoal("FooClass", "toString", this.objectType(), "NonNull");
        OutputCoverageTestFitness goal3 = new OutputCoverageTestFitness(outputGoal2);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToStringWithNull", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToStringReturningNonNull", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testOverloadedMethod() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "foo(I)");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(0)));
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "foo(II)");
        test3.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooTakingNoArguments", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooTakingInt", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooTaking2Arguments", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testOverloadedMethodDifferentArgArrayType() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo([B)");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        OutputCoverageTestFitness outputGoal = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "foo", this.stringType(), "False"));
        test1.addCoveredGoal((TestFitnessFunction)outputGoal);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "foo([I)");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)outputGoal);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooTakingByteArray", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooTakingIntArray", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testMultipleRedundantGoals() {
        MethodCoverageTestFitness methodGoal1 = new MethodCoverageTestFitness("FooClass", "foo(SS)Z");
        MethodCoverageTestFitness methodGoal2 = new MethodCoverageTestFitness("FooClass", "foo(Ljava/lang/Object;Ljava/lang/Object;)Z");
        OutputCoverageTestFitness outputGoal1 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "foo(SS)Z", Type.BOOLEAN_TYPE, "False"));
        OutputCoverageTestFitness outputGoal2 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "foo(Ljava/lang/Object;Ljava/lang/Object;)Z", Type.BOOLEAN_TYPE, "False"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)methodGoal1);
        test1.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)methodGoal2);
        test2.addCoveredGoal((TestFitnessFunction)outputGoal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooTaking2Shorts", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooTaking2Objects", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testOverloadedMethodWithObject() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "foo(Ljava/util/List;)");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooTakingNoArguments", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooTakingList", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testOverloadedMethodWithArray() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo(I)");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "foo([I)");
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(0)));
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "foo([[I)");
        test3.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooTakingInt", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooTakingIntArray", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooTakingIntArrayArray", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testTwoTestsDifferOnlyInBranches() {
        Branch b1 = (Branch)Mockito.mock(Branch.class);
        BytecodeInstruction bi = (BytecodeInstruction)Mockito.mock(BytecodeInstruction.class);
        Mockito.when((Object)b1.getInstruction()).thenReturn((Object)bi);
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "toString");
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        BranchCoverageTestFitness branchGoal1 = new BranchCoverageTestFitness(new BranchCoverageGoal(b1, true, "FooClass", "toStringBarFooBlubb", 0));
        test1.addCoveredGoal((TestFitnessFunction)branchGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        BranchCoverageTestFitness branchGoal2 = new BranchCoverageTestFitness(new BranchCoverageGoal(b1, false, "FooClass", "toString", 0));
        test2.addCoveredGoal((TestFitnessFunction)branchGoal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString0", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToString1", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testTwoUniqueMethods() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "bar");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testBarAndFoo", (Object)generatedName);
    }

    @Test
    public void testTwoUniqueMethodsWithLongNames() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "loremIpsumDolorSitAmetConsectetuerAdipiscingElit()V");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "sedDiamNonummNibhEuismodTinciduntUtLaoreetDoloreMagnaAliquamEratVolutpat()V");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testLoremIpsumDolorSitAmetConsectetuerAdipiscingElit", (Object)generatedName);
    }

    @Test
    public void testMultipleMethods() throws NoSuchMethodException {
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(Object.class.getConstructor(new Class[0]), Object.class);
        VariableReference callee = test.addStatement((Statement)new ConstructorStatement((TestCase)test, gc, new ArrayList()));
        GenericMethod gm = new GenericMethod(Object.class.getMethod("toString", new Class[0]), Object.class);
        test.addStatement((Statement)new MethodStatement((TestCase)test, gm, callee, new ArrayList()));
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "toString()Ljava/lang/String;");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "foo()Ljava/lang/String;");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "bar()Ljava/lang/String;");
        test.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testToString", (Object)generatedName);
    }

    @Test
    public void testTwoOutputGoals() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "toString", this.stringType(), "EmptyString");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        OutputCoverageGoal outputGoal2 = new OutputCoverageGoal("FooClass", "bar", this.objectType(), "NonNull");
        OutputCoverageTestFitness goal2 = new OutputCoverageTestFitness(outputGoal2);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testBarReturningNonNullAndToStringReturningEmptyString", (Object)generatedName);
    }

    @Test
    public void testTwoInputGoals() {
        DefaultTestCase test = new DefaultTestCase();
        InputCoverageGoal inputGoal1 = new InputCoverageGoal("FooClass", "foo", 0, this.objectType(), "NonNull");
        InputCoverageTestFitness goal1 = new InputCoverageTestFitness(inputGoal1);
        InputCoverageGoal inputGoal2 = new InputCoverageGoal("FooClass", "foo", 1, this.objectType(), "Null");
        InputCoverageTestFitness goal2 = new InputCoverageTestFitness(inputGoal2);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testFooWithNonNullAndNull", (Object)generatedName);
    }

    @Test
    public void testTwoMethodsOneWithException() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "bar");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ExceptionCoverageTestFitness goal3 = new ExceptionCoverageTestFitness("FooClass", "bar", RuntimeException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testBarThrowsRuntimeException", (Object)generatedName);
    }

    @Test
    public void testTwoTestsTwoMethodsOneWithException() {
        DefaultTestCase test1 = new DefaultTestCase();
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "foo");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "bar()I");
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ExceptionCoverageTestFitness goal3 = new ExceptionCoverageTestFitness("FooClass", "bar()I", RuntimeException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test1.addCoveredGoal((TestFitnessFunction)goal3);
        MethodNoExceptionCoverageTestFitness goal4 = new MethodNoExceptionCoverageTestFitness("FooClass", "bar()I");
        test2.addCoveredGoal((TestFitnessFunction)goal4);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName1 = naming.getName((TestCase)test1);
        String generatedName2 = naming.getName((TestCase)test2);
        Assert.assertEquals((Object)"testBarThrowsRuntimeException", (Object)generatedName1);
        Assert.assertEquals((Object)"testBar", (Object)generatedName2);
    }

    @Test
    public void testTwoConstructorsDifferentClasses() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("Foo", "<init>()");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("Bar", "<init>()");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testCreatesBarAndCreatesFoo", (Object)generatedName);
    }

    @Test
    public void testTwoConstructorsSameClass() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>()");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "<init>(I)");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testCreatesFooClassTakingNoArgumentsAndCreatesFooClassTakingInt", (Object)generatedName);
    }

    @Test
    public void testConstructorAndMethod() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("Foo", "<init>()");
        test.addCoveredGoal((TestFitnessFunction)goal1);
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("Foo", "bar()I");
        test.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testCreatesFooAndCallsBar", (Object)generatedName);
    }

    @Test
    public void testConstructorWithFullyQualifiedClassName() {
        DefaultTestCase test = new DefaultTestCase();
        MethodCoverageTestFitness goal = new MethodCoverageTestFitness("org.package.name.FooClass", "<init>()");
        test.addCoveredGoal((TestFitnessFunction)goal);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testCreatesFooClass", (Object)generatedName);
    }

    @Test
    public void testConstructorExceptionWithFullyQualifiedClassName() {
        DefaultTestCase test = new DefaultTestCase();
        ExceptionCoverageTestFitness goal = new ExceptionCoverageTestFitness("org.package.name.FooClass", "<init>()", RuntimeException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test.addCoveredGoal((TestFitnessFunction)goal);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName = naming.getName((TestCase)test);
        Assert.assertEquals((Object)"testFailsToCreateFooClassThrowsRuntimeException", (Object)generatedName);
    }

    @Test
    public void testOverloadedConstructor() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness(ClassWithOverloadedConstructor.class.getCanonicalName(), "<init>()");
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness(ClassWithOverloadedConstructor.class.getCanonicalName(), "<init>(Ljava/lang/String;)");
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test3 = new DefaultTestCase();
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness(ClassWithOverloadedConstructor.class.getCanonicalName(), "<init>(II)");
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName1 = naming.getName((TestCase)test1);
        String generatedName2 = naming.getName((TestCase)test2);
        String generatedName3 = naming.getName((TestCase)test3);
        Assert.assertEquals((Object)"testCreatesClassWithOverloadedConstructorTakingNoArguments", (Object)generatedName1);
        Assert.assertEquals((Object)"testCreatesClassWithOverloadedConstructorTakingString", (Object)generatedName2);
        Assert.assertEquals((Object)"testCreatesClassWithOverloadedConstructorTaking2Arguments", (Object)generatedName3);
    }

    @Test
    public void testExceptionInOverloadedConstructor() {
        DefaultTestCase test1 = new DefaultTestCase();
        ExceptionCoverageTestFitness goal1 = new ExceptionCoverageTestFitness(ClassWithOverloadedConstructor.class.getCanonicalName(), "<init>()", NullPointerException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        ExceptionCoverageTestFitness goal2 = new ExceptionCoverageTestFitness(ClassWithOverloadedConstructor.class.getCanonicalName(), "<init>(Ljava/lang/String;)", NullPointerException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        DefaultTestCase test3 = new DefaultTestCase();
        ExceptionCoverageTestFitness goal3 = new ExceptionCoverageTestFitness(ClassWithOverloadedConstructor.class.getCanonicalName(), "<init>(II)", NullPointerException.class, ExceptionCoverageTestFitness.ExceptionType.EXPLICIT);
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)goal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        String generatedName1 = naming.getName((TestCase)test1);
        String generatedName2 = naming.getName((TestCase)test2);
        String generatedName3 = naming.getName((TestCase)test3);
        Assert.assertEquals((Object)"testFailsToCreateClassWithOverloadedConstructorTakingNoArgumentsThrowsNullPointerException", (Object)generatedName1);
        Assert.assertEquals((Object)"testFailsToCreateClassWithOverloadedConstructorTakingStringThrowsNullPointerException", (Object)generatedName2);
        Assert.assertEquals((Object)"testFailsToCreateClassWithOverloadedConstructorTaking2ArgumentsThrowsNullPointerException", (Object)generatedName3);
    }

    @Test
    public void testBooleanOutputGoal() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", Type.BOOLEAN_TYPE, "True");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningTrue", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testNumericOutputGoal() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", Type.INT_TYPE, "Positive");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningPositive", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testCharOutputGoal() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", Type.CHAR_TYPE, "AlphabeticChar");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningAlphabeticChar", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testNullOutputGoal() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", Type.getType((String)"Ljava.lang.Object;"), "Null");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningNull", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testEmptyArray() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", Type.getType((String)"[Ljava.lang.Object;"), "EmptyArray");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningEmptyArray", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testStringOutputGoal() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", this.stringType(), "NonEmptyString");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningNonEmptyString", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testInspectorOutputGoal() {
        DefaultTestCase test = new DefaultTestCase();
        OutputCoverageGoal outputGoal1 = new OutputCoverageGoal("FooClass", "foo", this.stringType(), "NonNull:Bar:isFoo:Negative");
        OutputCoverageTestFitness goal1 = new OutputCoverageTestFitness(outputGoal1);
        test.addCoveredGoal((TestFitnessFunction)goal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningBarWhereIsFooIsNegative", (Object)naming.getName((TestCase)test));
    }

    @Test
    public void testLineCoverageIsExcluded() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "toString()");
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        LineCoverageTestFitness lineGoal1 = new LineCoverageTestFitness("FooClass", "toString()", Integer.valueOf(0));
        test1.addCoveredGoal((TestFitnessFunction)lineGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        LineCoverageTestFitness lineGoal2 = new LineCoverageTestFitness("FooClass", "toString()", Integer.valueOf(10));
        test2.addCoveredGoal((TestFitnessFunction)lineGoal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testToString0", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testToString1", (Object)naming.getName((TestCase)test2));
    }

    @Test
    public void testResolveBasicConflict() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        OutputCoverageGoal outputGoalHelper = new OutputCoverageGoal("FooClass", "foo(I)I", Type.INT_TYPE, "Zero");
        OutputCoverageTestFitness outputGoal1 = new OutputCoverageTestFitness(outputGoalHelper);
        test1.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        InputCoverageGoal inputGoalHelper = new InputCoverageGoal("FooClass", "foo(I)I", 0, Type.INT_TYPE, "Positive");
        InputCoverageTestFitness inputGoal1 = new InputCoverageTestFitness(inputGoalHelper);
        test2.addCoveredGoal((TestFitnessFunction)inputGoal1);
        DefaultTestCase test3 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal2 = new MethodCoverageTestFitness("FooClass", "toString()L/java/lang/String;");
        test3.addCoveredGoal((TestFitnessFunction)methodGoal2);
        test3.addCoveredGoal((TestFitnessFunction)methodGoal);
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)outputGoal1);
        test3.addCoveredGoal((TestFitnessFunction)inputGoal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningZero", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooWithPositive", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testToString", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testResolveConflict2() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        OutputCoverageGoal outputGoalHelper = new OutputCoverageGoal("FooClass", "foo(I)I", Type.INT_TYPE, "Zero");
        OutputCoverageTestFitness outputGoal1 = new OutputCoverageTestFitness(outputGoalHelper);
        test1.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        InputCoverageGoal inputGoalHelper = new InputCoverageGoal("FooClass", "foo(I)I", 0, Type.INT_TYPE, "Positive");
        InputCoverageTestFitness inputGoal1 = new InputCoverageTestFitness(inputGoalHelper);
        test2.addCoveredGoal((TestFitnessFunction)inputGoal1);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addCoveredGoal((TestFitnessFunction)methodGoal);
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)outputGoal1);
        test3.addCoveredGoal((TestFitnessFunction)inputGoal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningZero", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooWithPositive", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooReturningZeroAndFooWithPositive", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testResolveConflict3() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        OutputCoverageGoal outputGoalHelper = new OutputCoverageGoal("FooClass", "foo(I)I", Type.INT_TYPE, "Zero");
        OutputCoverageTestFitness outputGoal1 = new OutputCoverageTestFitness(outputGoalHelper);
        test1.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        InputCoverageGoal inputGoalHelper = new InputCoverageGoal("FooClass", "foo(I)I", 0, Type.INT_TYPE, "Positive");
        InputCoverageTestFitness inputGoal1 = new InputCoverageTestFitness(inputGoalHelper);
        test2.addCoveredGoal((TestFitnessFunction)inputGoal1);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)outputGoal1);
        test3.addCoveredGoal((TestFitnessFunction)inputGoal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooAndFooReturningZero", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooAndFooWithPositive", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooReturningZero", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testResolveConflict3WithMethodGoals() {
        MethodCoverageTestFitness methodGoal1 = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        MethodCoverageTestFitness methodGoal2 = new MethodCoverageTestFitness("FooClass", "bar(I)I");
        MethodCoverageTestFitness methodGoal3 = new MethodCoverageTestFitness("FooClass", "zoo(I)I");
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)methodGoal1);
        test1.addCoveredGoal((TestFitnessFunction)methodGoal2);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)methodGoal1);
        test2.addCoveredGoal((TestFitnessFunction)methodGoal3);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)methodGoal2);
        test3.addCoveredGoal((TestFitnessFunction)methodGoal3);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testBarAndFoo", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooAndZoo", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testBarAndZoo", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testResolveConflictWithManyTests() {
        Randomness.setSeed((long)0L);
        MethodCoverageTestFitness methodGoal1 = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        MethodCoverageTestFitness methodGoal2 = new MethodCoverageTestFitness("FooClass", "bar(I)I");
        MethodCoverageTestFitness methodGoal3 = new MethodCoverageTestFitness("FooClass", "zoo(I)I");
        MethodCoverageTestFitness methodGoal4 = new MethodCoverageTestFitness("FooClass", "gnu(I)I");
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)methodGoal1);
        test1.addCoveredGoal((TestFitnessFunction)methodGoal2);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)methodGoal1);
        test2.addCoveredGoal((TestFitnessFunction)methodGoal3);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)methodGoal1);
        test3.addCoveredGoal((TestFitnessFunction)methodGoal4);
        DefaultTestCase test4 = new DefaultTestCase();
        test4.addStatement((Statement)new IntPrimitiveStatement((TestCase)test4, Integer.valueOf(2)));
        test4.addCoveredGoal((TestFitnessFunction)methodGoal2);
        test4.addCoveredGoal((TestFitnessFunction)methodGoal3);
        DefaultTestCase test5 = new DefaultTestCase();
        test5.addStatement((Statement)new IntPrimitiveStatement((TestCase)test5, Integer.valueOf(3)));
        test5.addCoveredGoal((TestFitnessFunction)methodGoal2);
        test5.addCoveredGoal((TestFitnessFunction)methodGoal4);
        DefaultTestCase test6 = new DefaultTestCase();
        test6.addStatement((Statement)new IntPrimitiveStatement((TestCase)test6, Integer.valueOf(4)));
        test6.addCoveredGoal((TestFitnessFunction)methodGoal3);
        test6.addCoveredGoal((TestFitnessFunction)methodGoal4);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        tests.add(test4);
        tests.add(test5);
        tests.add(test6);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testBarAndFoo", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooAndZoo", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooAndGnu", (Object)naming.getName((TestCase)test3));
        Assert.assertEquals((Object)"testBarAndZoo", (Object)naming.getName((TestCase)test4));
        Assert.assertEquals((Object)"testBarAndGnu", (Object)naming.getName((TestCase)test5));
        Assert.assertEquals((Object)"testGnuAndZoo", (Object)naming.getName((TestCase)test6));
    }

    @Test
    public void testResolveConflictWithTwoMethods() {
        DefaultTestCase test1 = new DefaultTestCase();
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        OutputCoverageGoal outputGoalHelper = new OutputCoverageGoal("FooClass", "foo(I)I", Type.INT_TYPE, "Zero");
        OutputCoverageTestFitness outputGoal1 = new OutputCoverageTestFitness(outputGoalHelper);
        test1.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        InputCoverageGoal inputGoalHelper = new InputCoverageGoal("FooClass", "foo(I)I", 0, Type.INT_TYPE, "Positive");
        InputCoverageTestFitness inputGoal1 = new InputCoverageTestFitness(inputGoalHelper);
        test2.addCoveredGoal((TestFitnessFunction)inputGoal1);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addCoveredGoal((TestFitnessFunction)methodGoal);
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)outputGoal1);
        test3.addCoveredGoal((TestFitnessFunction)inputGoal1);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningZero", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooWithPositive", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooReturningZeroAndFooWithPositive", (Object)naming.getName((TestCase)test3));
    }

    @Test
    public void testResolveConflictInputsOutputs() {
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("FooClass", "foo(I)I");
        OutputCoverageGoal outputGoalHelper1 = new OutputCoverageGoal("FooClass", "foo(I)I", Type.INT_TYPE, "Positive");
        OutputCoverageTestFitness outputGoal1 = new OutputCoverageTestFitness(outputGoalHelper1);
        OutputCoverageGoal outputGoalHelper2 = new OutputCoverageGoal("FooClass", "foo(I)I", Type.INT_TYPE, "Negative");
        OutputCoverageTestFitness outputGoal2 = new OutputCoverageTestFitness(outputGoalHelper2);
        InputCoverageGoal inputGoalHelper1 = new InputCoverageGoal("FooClass", "foo(I)I", 0, Type.INT_TYPE, "Positive");
        InputCoverageTestFitness inputGoal1 = new InputCoverageTestFitness(inputGoalHelper1);
        InputCoverageGoal inputGoalHelper2 = new InputCoverageGoal("FooClass", "foo(I)I", 0, Type.INT_TYPE, "Negative");
        InputCoverageTestFitness inputGoal2 = new InputCoverageTestFitness(inputGoalHelper2);
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        test1.addCoveredGoal((TestFitnessFunction)inputGoal1);
        test1.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addCoveredGoal((TestFitnessFunction)inputGoal2);
        test2.addCoveredGoal((TestFitnessFunction)outputGoal2);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)methodGoal);
        test3.addCoveredGoal((TestFitnessFunction)inputGoal2);
        test3.addCoveredGoal((TestFitnessFunction)outputGoal1);
        DefaultTestCase test4 = new DefaultTestCase();
        test4.addStatement((Statement)new IntPrimitiveStatement((TestCase)test4, Integer.valueOf(2)));
        test4.addCoveredGoal((TestFitnessFunction)methodGoal);
        test4.addCoveredGoal((TestFitnessFunction)inputGoal1);
        test4.addCoveredGoal((TestFitnessFunction)outputGoal2);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        tests.add(test4);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testFooReturningPositiveAndFooWithPositive", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testFooReturningNegativeAndFooWithNegative", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testFooReturningPositiveAndFooWithNegative", (Object)naming.getName((TestCase)test3));
        Assert.assertEquals((Object)"testFooReturningNegativeAndFooWithPositive", (Object)naming.getName((TestCase)test4));
    }

    @Test
    public void testResolveMethodNames() {
        MethodCoverageTestFitness methodGoal = new MethodCoverageTestFitness("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z");
        MethodNoExceptionCoverageTestFitness methodNoExGoal = new MethodNoExceptionCoverageTestFitness("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z");
        OutputCoverageGoal outputGoalHelper1 = new OutputCoverageGoal("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z", Type.BOOLEAN_TYPE, "False");
        OutputCoverageTestFitness outputGoalFalse = new OutputCoverageTestFitness(outputGoalHelper1);
        OutputCoverageGoal outputGoalHelper2 = new OutputCoverageGoal("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z", Type.BOOLEAN_TYPE, "True");
        OutputCoverageTestFitness outputGoalTrue = new OutputCoverageTestFitness(outputGoalHelper2);
        InputCoverageGoal inputGoalHelper1 = new InputCoverageGoal("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z", 0, Type.getType(Set.class), "EmptySet");
        InputCoverageTestFitness inputGoalEmptySet = new InputCoverageTestFitness(inputGoalHelper1);
        InputCoverageGoal inputGoalHelper2 = new InputCoverageGoal("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z", 0, Type.getType(Set.class), "NonEmptySet");
        InputCoverageTestFitness inputGoalNonEmptySet = new InputCoverageTestFitness(inputGoalHelper2);
        InputCoverageGoal inputGoalHelper3 = new InputCoverageGoal("org.apache.commons.scxml.Builtin", "isMember(Ljava/util/Set;Ljava/lang/String;)Z", 1, Type.getType(String.class), "NonEmptyString");
        InputCoverageTestFitness inputGoalStringNonEmpty = new InputCoverageTestFitness(inputGoalHelper3);
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)methodGoal);
        test1.addCoveredGoal((TestFitnessFunction)methodNoExGoal);
        test1.addCoveredGoal((TestFitnessFunction)inputGoalEmptySet);
        test1.addCoveredGoal((TestFitnessFunction)inputGoalStringNonEmpty);
        test1.addCoveredGoal((TestFitnessFunction)outputGoalFalse);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(0)));
        test2.addCoveredGoal((TestFitnessFunction)methodGoal);
        test2.addCoveredGoal((TestFitnessFunction)methodNoExGoal);
        test2.addCoveredGoal((TestFitnessFunction)inputGoalNonEmptySet);
        test2.addCoveredGoal((TestFitnessFunction)inputGoalStringNonEmpty);
        test2.addCoveredGoal((TestFitnessFunction)outputGoalFalse);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(1)));
        test3.addCoveredGoal((TestFitnessFunction)methodGoal);
        test3.addCoveredGoal((TestFitnessFunction)methodNoExGoal);
        test3.addCoveredGoal((TestFitnessFunction)inputGoalNonEmptySet);
        test3.addCoveredGoal((TestFitnessFunction)inputGoalStringNonEmpty);
        test3.addCoveredGoal((TestFitnessFunction)outputGoalTrue);
        ArrayList<DefaultTestCase> tests = new ArrayList<DefaultTestCase>();
        tests.add(test1);
        tests.add(test2);
        tests.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(tests);
        Assert.assertEquals((Object)"testIsMemberWithEmptySet", (Object)naming.getName((TestCase)test1));
        Assert.assertEquals((Object)"testIsMemberReturningFalse", (Object)naming.getName((TestCase)test2));
        Assert.assertEquals((Object)"testIsMemberReturningTrue", (Object)naming.getName((TestCase)test3));
    }

    private Type stringType() {
        return Type.getType((String)"Ljava.lang.String;");
    }

    private Type objectType() {
        return Type.getType((String)"Ljava.lang.Object;");
    }
}

