/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.naming.methods;

import java.util.ArrayList;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.coverage.io.input.InputCoverageGoal;
import org.evosuite.coverage.io.input.InputCoverageTestFitness;
import org.evosuite.coverage.io.output.OutputCoverageGoal;
import org.evosuite.coverage.io.output.OutputCoverageTestFitness;
import org.evosuite.coverage.method.MethodCoverageTestFitness;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.junit.naming.methods.CoverageGoalTestNameGenerationStrategy;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Type;

public class TestMethodNamingComplexExamples {
    @Test
    public void testTwoTestsOutputGoals() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "keys()[I");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "<init>(LFooClass;)V");
        OutputCoverageTestFitness goal3 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "keys()", Type.INT_TYPE, "Negative"));
        OutputCoverageTestFitness goal4 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "keys()", Type.INT_TYPE, "Positive"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test1.addCoveredGoal((TestFitnessFunction)goal3);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)goal4);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testKeysTakingNoArgumentsReturningNegative", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testKeysTakingNoArgumentsReturningPositive", (Object)nameTest2);
    }

    @Test
    public void testThreeTestsOutputGoals() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "mist(I)V");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "keys()");
        OutputCoverageTestFitness goal3 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "keys()", Type.INT_TYPE, "Positive"));
        OutputCoverageTestFitness goal4 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "keys()", Type.INT_TYPE, "Negative"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(3)));
        test3.addCoveredGoal((TestFitnessFunction)goal1);
        test3.addCoveredGoal((TestFitnessFunction)goal2);
        test3.addCoveredGoal((TestFitnessFunction)goal4);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        testCases.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        String nameTest3 = naming.getName((TestCase)test3);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testMist", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testKeysReturningPositive", (Object)nameTest2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testKeysReturningNegative", (Object)nameTest3);
    }

    @Test
    public void testOverloadedMethods() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>(LFooClass;)V");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "values([B)[B");
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "values([I)[B");
        OutputCoverageTestFitness goal4 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values([B)", Type.getType((String)"[B"), "EmptyArray"));
        OutputCoverageTestFitness goal5 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values([I)", Type.getType((String)"[B"), "NonEmptyArray"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test1.addCoveredGoal((TestFitnessFunction)goal4);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal5);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingByteArray", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingIntArray", (Object)nameTest2);
    }

    @Test
    public void testOverloadedMethodsNoArgs() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>(LFooClass;)V");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "values([B)[B");
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "values()[B");
        OutputCoverageTestFitness goal4 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values([B)", Type.getType((String)"[B"), "EmptyArray"));
        OutputCoverageTestFitness goal5 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values()", Type.getType((String)"[B"), "NonEmptyArray"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test1.addCoveredGoal((TestFitnessFunction)goal4);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal5);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingByteArray", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingNoArguments", (Object)nameTest2);
    }

    @Test
    public void testConstructors() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>(LFooClass;)V");
        ExceptionCoverageTestFitness goal2 = new ExceptionCoverageTestFitness("FooClass", "<init>(LFooClass;)V", ArrayIndexOutOfBoundsException.class, ExceptionCoverageTestFitness.ExceptionType.IMPLICIT);
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testCreatesFooClass", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testFailsToCreateFooClassThrowsArrayIndexOutOfBoundsException", (Object)nameTest2);
    }

    @Test
    public void testExactSameTests() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "values([B)[B");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "values()[B");
        OutputCoverageTestFitness goal4 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values([B)", Type.getType((String)"[B"), "EmptyArray"));
        OutputCoverageTestFitness goal5 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values()", Type.getType((String)"[B"), "NonEmptyArray"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test1.addCoveredGoal((TestFitnessFunction)goal4);
        test1.addCoveredGoal((TestFitnessFunction)goal5);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)goal4);
        test2.addCoveredGoal((TestFitnessFunction)goal5);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingNoArgumentsReturningNonEmptyArray", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingByteArrayReturningEmptyArray", (Object)nameTest2);
    }

    @Test
    public void testConstructorAndOverloadedMethods() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>(LFooClass;)V");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "values()[B");
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "values([B)[B");
        ExceptionCoverageTestFitness goal4 = new ExceptionCoverageTestFitness("FooClass", "<init>(LFooClass;)V", ArrayIndexOutOfBoundsException.class, ExceptionCoverageTestFitness.ExceptionType.IMPLICIT);
        OutputCoverageTestFitness goal5 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values()", Type.getType((String)"[B"), "NonEmptyArray"));
        OutputCoverageTestFitness goal6 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "values([B)", Type.getType((String)"[B"), "EmptyArray"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test1.addCoveredGoal((TestFitnessFunction)goal3);
        test1.addCoveredGoal((TestFitnessFunction)goal5);
        test1.addCoveredGoal((TestFitnessFunction)goal6);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal4);
        test2.addCoveredGoal((TestFitnessFunction)goal5);
        test2.addCoveredGoal((TestFitnessFunction)goal6);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testValuesTakingNoArgumentsReturningNonEmptyArray", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testFailsToCreateFooClassThrowsArrayIndexOutOfBoundsException", (Object)nameTest2);
    }

    @Test
    public void testIDNamingWithSameMethodGoals() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>()V");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "getPublicID()Ljava/lang/String;");
        MethodCoverageTestFitness goal3 = new MethodCoverageTestFitness("FooClass", "setPublicID(Ljava/lang/String;)LFooClass;");
        OutputCoverageTestFitness goal4 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "getPublicID()", Type.getType((String)"Ljava.lang.String;"), "NonNull"));
        OutputCoverageTestFitness goal5 = new OutputCoverageTestFitness(new OutputCoverageGoal("FooClass", "setPublicID(Ljava/lang/String;)", Type.getType((String)"LFooClass;"), "NonNull"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addStatement((Statement)new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(1)));
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal2);
        test1.addCoveredGoal((TestFitnessFunction)goal4);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal1);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal5);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testGetPublicIDTakingNoArguments", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testSetPublicIDTakingString", (Object)nameTest2);
    }

    @Test
    public void testIDNamingWithSameMethodGoals2() throws NoSuchMethodException, ConstructionFailedException, ClassNotFoundException {
        MethodCoverageTestFitness goal1 = new MethodCoverageTestFitness("FooClass", "<init>(LField;II)V");
        MethodCoverageTestFitness goal2 = new MethodCoverageTestFitness("FooClass", "<init>(LFieldMatrix;)V");
        ExceptionCoverageTestFitness goal3 = new ExceptionCoverageTestFitness("FooClass", "<init>(LField;II)V", ArrayIndexOutOfBoundsException.class, ExceptionCoverageTestFitness.ExceptionType.IMPLICIT);
        InputCoverageTestFitness goal4 = new InputCoverageTestFitness(new InputCoverageGoal("FooClass", "<init>(LFieldMatrix;)V", 0, Type.getType((String)"LFieldMatrix;"), "Null"));
        InputCoverageTestFitness goal5 = new InputCoverageTestFitness(new InputCoverageGoal("FooClass", "<init>(LFieldMatrix;)V", 0, Type.getType((String)"LFieldMatrix;"), "NonNull"));
        InputCoverageTestFitness goal6 = new InputCoverageTestFitness(new InputCoverageGoal("FooClass", "<init>(LField;II)V", 0, Type.getType((String)"LField;"), "NonNull"));
        InputCoverageTestFitness goal7 = new InputCoverageTestFitness(new InputCoverageGoal("FooClass", "<init>(LField;II)V", 1, Type.INT_TYPE, "Zero"));
        InputCoverageTestFitness goal8 = new InputCoverageTestFitness(new InputCoverageGoal("FooClass", "<init>(LField;II)V", 1, Type.INT_TYPE, "Negative"));
        InputCoverageTestFitness goal9 = new InputCoverageTestFitness(new InputCoverageGoal("FooClass", "<init>(LField;II)V", 2, Type.INT_TYPE, "Zero"));
        DefaultTestCase test1 = new DefaultTestCase();
        test1.addCoveredGoal((TestFitnessFunction)goal1);
        test1.addCoveredGoal((TestFitnessFunction)goal3);
        test1.addCoveredGoal((TestFitnessFunction)goal6);
        test1.addCoveredGoal((TestFitnessFunction)goal7);
        test1.addCoveredGoal((TestFitnessFunction)goal9);
        DefaultTestCase test2 = new DefaultTestCase();
        test2.addStatement((Statement)new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(2)));
        test2.addCoveredGoal((TestFitnessFunction)goal2);
        test2.addCoveredGoal((TestFitnessFunction)goal3);
        test2.addCoveredGoal((TestFitnessFunction)goal4);
        DefaultTestCase test3 = new DefaultTestCase();
        test3.addStatement((Statement)new IntPrimitiveStatement((TestCase)test3, Integer.valueOf(3)));
        test3.addCoveredGoal((TestFitnessFunction)goal1);
        test3.addCoveredGoal((TestFitnessFunction)goal2);
        test3.addCoveredGoal((TestFitnessFunction)goal3);
        test3.addCoveredGoal((TestFitnessFunction)goal5);
        test3.addCoveredGoal((TestFitnessFunction)goal6);
        test3.addCoveredGoal((TestFitnessFunction)goal8);
        ArrayList<DefaultTestCase> testCases = new ArrayList<DefaultTestCase>();
        testCases.add(test1);
        testCases.add(test2);
        testCases.add(test3);
        CoverageGoalTestNameGenerationStrategy naming = new CoverageGoalTestNameGenerationStrategy(testCases);
        String nameTest1 = naming.getName((TestCase)test1);
        String nameTest2 = naming.getName((TestCase)test2);
        String nameTest3 = naming.getName((TestCase)test3);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testCreatesFooClassTaking3ArgumentsWithZeroAndZero", (Object)nameTest1);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testCreatesFooClassTakingFieldMatrixWithNull", (Object)nameTest2);
        Assert.assertEquals((String)"Generated test name differs from expected", (Object)"testCreatesFooClassTaking3ArgumentsWithNegative", (Object)nameTest3);
    }
}

