/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.mock.java.io;

import com.examples.with.different.packagename.mock.java.io.ExtendingFile;
import java.io.File;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParentReplacementTest {
    private static final boolean USING_VFS = Properties.VIRTUAL_FS;

    @After
    public void reset() {
        RuntimeSettings.useVFS = USING_VFS;
        Properties.VIRTUAL_FS = USING_VFS;
    }

    @Before
    public void init() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
    }

    @Test
    public void testNoVFS() throws ClassNotFoundException {
        RuntimeSettings.useVFS = false;
        Properties.VIRTUAL_FS = false;
        InstrumentingClassLoader cl = new InstrumentingClassLoader();
        Class clazz = cl.loadClass(ExtendingFile.class.getCanonicalName());
        Class parent = clazz.getSuperclass();
        Assert.assertEquals((Object)File.class.getCanonicalName(), (Object)parent.getCanonicalName());
    }

    @Test
    public void testWithVFS() throws ClassNotFoundException {
        RuntimeSettings.useVFS = true;
        Properties.VIRTUAL_FS = true;
        InstrumentingClassLoader cl = new InstrumentingClassLoader();
        Class clazz = cl.loadClass(ExtendingFile.class.getCanonicalName());
        Class parent = clazz.getSuperclass();
        Assert.assertEquals((Object)MockFile.class.getCanonicalName(), (Object)parent.getCanonicalName());
    }
}

