/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import com.examples.with.different.packagename.ClassWithPublicField;
import java.util.HashMap;
import org.evosuite.Properties;
import org.evosuite.regression.ObjectDistanceCalculator;
import org.junit.Assert;
import org.junit.Test;

public class ObjectDistanceCalculatorTest {
    private static final String HELLO = "hello";

    private double getDistance(Object p, Object q) {
        double distance = ObjectDistanceCalculator.getObjectDistance((Object)p, (Object)q);
        double distanceReverse = ObjectDistanceCalculator.getObjectDistance((Object)q, (Object)p);
        Assert.assertEquals((double)distance, (double)distanceReverse, (double)Double.MIN_VALUE);
        return distance;
    }

    @Test
    public void differentNanDouble() {
        double distance = this.getDistance(Double.NaN, 42.0);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void differentNanFloat() {
        double distance = this.getDistance(Float.valueOf(Float.NaN), Float.valueOf(42.0f));
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void differentNanDoubleFloat() {
        double distance = this.getDistance(Double.NaN, Float.valueOf(Float.NaN));
        Assert.assertEquals((double)0.5, (double)distance, (double)0.001);
    }

    @Test
    public void differentNanFloatDouble() {
        double distance = this.getDistance(Float.valueOf(42.0f), Double.NaN);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void differentInfinity() {
        double distance = this.getDistance(Float.valueOf(Float.POSITIVE_INFINITY), Double.NaN);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void differentInfinity_sameType() {
        double distance = this.getDistance(Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NaN));
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void differentInfinity_positiveInfinity() {
        double distance = this.getDistance(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void differentInfinity_double() {
        double distance = this.getDistance(Double.POSITIVE_INFINITY, Double.NaN);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void infinityVsNumeric() {
        double distance = this.getDistance(Double.POSITIVE_INFINITY, 42.0);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void enumVsDouble() {
        double distance = this.getDistance(Properties.Algorithm.MONOTONIC_GA, 42.0);
        Assert.assertEquals((double)1.0, (double)distance, (double)0.001);
    }

    @Test
    public void enumVsEnum() {
        double distance = this.getDistance(Properties.Algorithm.MONOTONIC_GA, Properties.Algorithm.STANDARD_GA);
        Assert.assertEquals((double)1.4, (double)distance, (double)0.001);
    }

    @Test
    public void stringVsString() {
        Assert.assertEquals((double)0.0, (double)this.getDistance(HELLO, HELLO), (double)0.001);
        Assert.assertEquals((double)1.0, (double)this.getDistance("helloo", HELLO), (double)0.001);
        Assert.assertEquals((double)1.166, (double)this.getDistance("hellooo", HELLO), (double)0.001);
        Assert.assertEquals((double)1.25, (double)this.getDistance("helloooo", HELLO), (double)0.001);
        Assert.assertEquals((double)1.333, (double)this.getDistance("helloooooo", HELLO), (double)0.001);
        Assert.assertEquals((double)1.357, (double)this.getDistance("hAlloooooo", HELLO), (double)0.001);
        Assert.assertEquals((double)1.388, (double)this.getDistance("hellooooooooo", HELLO), (double)0.001);
        Assert.assertEquals((double)1.437, (double)this.getDistance("helloooooooooooooooo", HELLO), (double)0.001);
    }

    @Test
    public void charDiff() {
        Assert.assertEquals((double)1.0, (double)this.getDistance(Character.valueOf('a'), Character.valueOf('b')), (double)0.001);
        Assert.assertEquals((double)1.461, (double)this.getDistance(Character.valueOf('a'), Character.valueOf('z')), (double)0.001);
        Assert.assertEquals((double)1.469, (double)this.getDistance(Character.valueOf('a'), Character.valueOf('A')), (double)0.001);
    }

    @Test
    public void boolDiff() {
        Assert.assertEquals((double)1.0, (double)this.getDistance(true, false), (double)0.001);
        Assert.assertEquals((double)1.0, (double)this.getDistance(Boolean.TRUE, false), (double)0.001);
        Assert.assertEquals((double)1.0, (double)this.getDistance(Boolean.FALSE, true), (double)0.001);
    }

    @Test
    public void longDiff() {
        Assert.assertEquals((double)0.5, (double)this.getDistance(42L, 42), (double)0.001);
        Assert.assertEquals((double)0.5, (double)this.getDistance(42L, 42.0), (double)0.001);
        Assert.assertEquals((double)0.5, (double)this.getDistance(Long.MAX_VALUE, Double.MAX_VALUE), (double)0.001);
        Assert.assertEquals((double)1.0, (double)this.getDistance(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL), (double)0.001);
        Assert.assertEquals((double)1.166, (double)this.getDistance(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFDL), (double)0.001);
        Assert.assertEquals((double)1.409, (double)this.getDistance(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFF5L), (double)0.001);
    }

    @Test
    public void doubleDiff() {
        Assert.assertEquals((double)0.5, (double)this.getDistance(42, 42.0), (double)0.001);
        Assert.assertEquals((double)1.5, (double)this.getDistance(Double.MAX_VALUE, Double.MIN_VALUE), (double)0.001);
        Assert.assertEquals((double)0.5, (double)this.getDistance(Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE)), (double)0.001);
    }

    @Test
    public void objectDiff_Basic() {
        ClassWithPublicField p = new ClassWithPublicField();
        ClassWithPublicField q = new ClassWithPublicField();
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)Double.MIN_VALUE);
        p.x = 43;
        q.x = 42;
        Assert.assertEquals((double)0.666, (double)this.getDistance(p, q), (double)0.001);
        p.y = HELLO;
        q.y = "hell";
        Assert.assertEquals((double)1.0, (double)this.getDistance(p, q), (double)0.001);
        q.x = 43;
        Assert.assertEquals((double)0.666, (double)this.getDistance(p, q), (double)0.001);
        q.z = new Integer(43);
        Assert.assertEquals((double)1.0, (double)this.getDistance(p, q), (double)0.001);
        q.z = new Integer(43000);
        Assert.assertEquals((double)1.166, (double)this.getDistance(p, q), (double)0.001);
    }

    @Test
    public void objectDiff_Nested() {
        NestedBasicObjectWithPublicFields p = this.constructNestedObject();
        NestedBasicObjectWithPublicFields q = this.constructNestedObject();
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)0.001);
        q.foo.x = 5000;
        Assert.assertEquals((double)0.583, (double)this.getDistance(p, q), (double)0.001);
        q.self.foo.x = 5000;
        Assert.assertEquals((double)0.77, (double)this.getDistance(p, q), (double)0.001);
        q.self.foo.y = "bFoo";
        Assert.assertEquals((double)0.868, (double)this.getDistance(p, q), (double)0.001);
    }

    @Test
    public void objectDiff_DifferentObjects() {
        NestedBasicObjectWithPublicFields p = this.constructNestedObject();
        ClassWithPublicField q = new ClassWithPublicField();
        Assert.assertEquals((double)0.5, (double)this.getDistance(p, q), (double)0.001);
    }

    @Test
    public void mapDiff() {
        HashMap<String, Object> p = new HashMap<String, Object>();
        HashMap<String, Object> q = new HashMap<String, Object>();
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)0.001);
        p.put("foo", 42);
        q.put("foo", 42);
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)0.001);
        q.put("foo", 43);
        Assert.assertEquals((double)0.833, (double)this.getDistance(p, q), (double)0.001);
        p.put("bar", this.constructNestedObject());
        q.put("bar", 43);
        Assert.assertEquals((double)1.1, (double)this.getDistance(p, q), (double)0.001);
        q.put("bar", this.constructNestedObject());
        Assert.assertEquals((double)0.833, (double)this.getDistance(p, q), (double)0.001);
        ((NestedBasicObjectWithPublicFields)q.get((Object)"bar")).foo.x = 5000;
        Assert.assertEquals((double)1.035, (double)this.getDistance(p, q), (double)0.001);
        ((NestedBasicObjectWithPublicFields)q.get((Object)"bar")).bar.y = "bFoo";
        Assert.assertEquals((double)1.134, (double)this.getDistance(p, q), (double)0.001);
        q.put("buzz", 1);
        Assert.assertEquals((double)1.329, (double)this.getDistance(p, q), (double)0.001);
    }

    @Test
    public void mapDiff_NonStringObject() {
        HashMap<Integer, String> p = new HashMap<Integer, String>();
        HashMap<Integer, String> q = new HashMap<Integer, String>();
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)0.001);
        p.put(42, "foo");
        q.put(42, "foo");
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)0.001);
        q.put(42, "bar");
        Assert.assertEquals((double)0.0, (double)this.getDistance(p, q), (double)0.001);
    }

    private NestedBasicObjectWithPublicFields constructNestedObject() {
        NestedBasicObjectWithPublicFields constructed = new NestedBasicObjectWithPublicFields(new ClassWithPublicField(), new ClassWithPublicField());
        constructed.foo.x = 10;
        constructed.foo.y = "aFoo";
        constructed.foo.z = 100;
        return constructed;
    }

    class NestedBasicObjectWithPublicFields {
        ClassWithPublicField foo;
        ClassWithPublicField bar;
        NestedBasicObjectWithPublicFields self;

        NestedBasicObjectWithPublicFields() {
            this.foo = new ClassWithPublicField();
            this.bar = new ClassWithPublicField();
        }

        NestedBasicObjectWithPublicFields(ClassWithPublicField foo, ClassWithPublicField bar) {
            this.foo = foo;
            this.bar = bar;
            this.self = new NestedBasicObjectWithPublicFields();
            ++this.self.foo.x;
            this.self.foo.y = this.self.foo.y + "o";
            ClassWithPublicField classWithPublicField = this.self.foo;
            Integer n = classWithPublicField.z;
            Integer n2 = classWithPublicField.z = Integer.valueOf(classWithPublicField.z + 1);
            this.self.bar.x += 2;
            this.self.bar.y = this.self.bar.y + "oo";
            classWithPublicField = this.self.bar;
            classWithPublicField.z = classWithPublicField.z + 2;
        }
    }
}

