/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import org.evosuite.seeding.DynamicConstantVariableProbabilityPool;
import org.evosuite.seeding.StaticConstantVariableProbabilityPool;
import org.junit.Assert;
import org.junit.Test;

public class TestVariableConstantPool {
    @Test
    public void testBasicProbabilities() {
        StaticConstantVariableProbabilityPool pool1 = new StaticConstantVariableProbabilityPool();
        StaticConstantVariableProbabilityPool pool2 = new StaticConstantVariableProbabilityPool();
        for (int i = 0; i < 99; ++i) {
            pool1.add((Object)"Foo");
            pool2.add((Object)"Bar");
        }
        pool1.add((Object)"Bar");
        pool2.add((Object)"Foo");
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 100; ++i) {
            if (pool1.getRandomString().equals("Bar")) {
                ++count1;
            }
            if (!pool2.getRandomString().equals("Bar")) continue;
            ++count2;
        }
        Assert.assertTrue((count1 < count2 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicProbabilitiesDynamic() {
        DynamicConstantVariableProbabilityPool pool1 = new DynamicConstantVariableProbabilityPool();
        DynamicConstantVariableProbabilityPool pool2 = new DynamicConstantVariableProbabilityPool();
        for (int i = 0; i < 99; ++i) {
            pool1.add((Object)"Foo");
            pool2.add((Object)"Bar");
        }
        pool1.add((Object)"Bar");
        pool2.add((Object)"Foo");
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 100; ++i) {
            if (pool1.getRandomString().equals("Bar")) {
                ++count1;
            }
            if (!pool2.getRandomString().equals("Bar")) continue;
            ++count2;
        }
        Assert.assertTrue((count1 < count2 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicProbabilitiesDynamicUpdate() {
        int i;
        DynamicConstantVariableProbabilityPool pool = new DynamicConstantVariableProbabilityPool();
        for (int i2 = 0; i2 < 99; ++i2) {
            pool.add((Object)"Foo");
        }
        pool.add((Object)"Bar");
        int count1 = 0;
        for (i = 0; i < 100; ++i) {
            if (!pool.getRandomString().equals("Bar")) continue;
            ++count1;
        }
        for (i = 0; i < 99; ++i) {
            pool.add((Object)"Bar");
        }
        int count2 = 0;
        for (int i3 = 0; i3 < 100; ++i3) {
            if (!pool.getRandomString().equals("Bar")) continue;
            ++count2;
        }
        Assert.assertTrue((count1 < count2 ? 1 : 0) != 0);
    }
}

