/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import com.examples.with.different.packagename.AccessExamples;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.evosuite.Properties;
import org.evosuite.setup.TestUsageChecker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestAccessField {
    @After
    public void resetProperties() {
        Properties.CLASS_PREFIX = "";
        Properties.TARGET_CLASS = "";
    }

    @Test
    public void testPublicField() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"publicField");
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDefaultField() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"defaultField", (boolean)true);
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testProtectedField() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"protectedField", (boolean)true);
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPrivateField() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"privateField", (boolean)true);
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPublicFieldTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"publicField");
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDefaultFieldTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"defaultField", (boolean)true);
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testProtectedFieldTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"protectedField", (boolean)true);
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPrivateFieldTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Field f = FieldUtils.getField(AccessExamples.class, (String)"privateField", (boolean)true);
        boolean result = TestUsageChecker.canUse((Field)f);
        Assert.assertFalse((boolean)result);
    }
}

