/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import com.examples.with.different.packagename.AccessExamples;
import com.examples.with.different.packagename.ArrayStack;
import com.examples.with.different.packagename.otherpackage.ExampleWithStaticPackagePrivateInnerClass;
import com.examples.with.different.packagename.subpackage.AccessExamplesSubclass;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestAccessMethod {
    @After
    public void resetProperties() {
        Properties.CLASS_PREFIX = "";
        Properties.TARGET_CLASS = "";
    }

    protected Method getMethod(Class<?> clazz, String name) {
        Set methods = TestClusterUtils.getMethods(clazz);
        for (Method m : methods) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        Assert.fail((String)("No such method: " + name));
        return null;
    }

    @Test
    public void testPublicMethod() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method f = this.getMethod(AccessExamples.class, "publicMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDefaultMethod() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method f = this.getMethod(AccessExamples.class, "defaultMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testProtectedMethod() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method f = this.getMethod(AccessExamples.class, "protectedMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPrivateMethod() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method f = this.getMethod(AccessExamples.class, "privateMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPublicMethodTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamples.class, "publicMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDefaultMethodTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamples.class, "defaultMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDefaultMethodInSuperClass() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamples.class, "defaultMethodInSuperClass");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testProtectedMethodTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamples.class, "protectedMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPrivateMethodTargetPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamples.class, "privateMethod");
        boolean result = TestUsageChecker.canUse((Method)f);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPublicMethodTargetSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename.subpackage";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.subpackage.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "publicMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testProtectedMethodTargetSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename.subpackage";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.subpackage.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "protectedMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testDefaultMethodTargetSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename.subpackage";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.subpackage.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "defaultMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPrivateMethodTargetSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename.subpackage";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.subpackage.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "privateMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPublicMethodTargetFromSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "publicMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testProtectedMethodTargetFromSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "protectedMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testDefaultMethodTargetFromSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "defaultMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testPrivateMethodTargetFromSubPackage() {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.Foo";
        Method f = this.getMethod(AccessExamplesSubclass.class, "privateMethod");
        boolean result = TestUsageChecker.canUse((Method)f, AccessExamplesSubclass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testArrayListBug() {
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.ArrayStack";
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        try {
            Method m = this.getMethod(ArrayList.class, "elementData");
            boolean result = TestUsageChecker.canUse((Method)m, ArrayStack.class);
            Assert.assertFalse((boolean)result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testMethodReturnsUnaccessibleClass() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method m = this.getMethod(ExampleWithStaticPackagePrivateInnerClass.class, "getFoo");
        boolean result = TestUsageChecker.canUse((Method)m, ExampleWithStaticPackagePrivateInnerClass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testMethodReturnsUnaccessibleClass2() throws ClassNotFoundException {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.ClassWithPrivateInnerClass";
        Class<?> clazz = Class.forName("com.examples.with.different.packagename.ClassWithPrivateInnerClass");
        Method m = this.getMethod(clazz, "getProperty");
        boolean result = TestUsageChecker.canUse((Method)m, clazz);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testMethodReturnsUnaccessibleClass3() throws ClassNotFoundException {
        Properties.CLASS_PREFIX = "com.examples.with.different.packagename";
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.ClassWithPrivateInnerClass";
        Class<?> clazz = Class.forName("com.examples.with.different.packagename.ClassWithPrivateInnerClass");
        Method m = this.getMethod(clazz, "getPropertyList");
        boolean result = TestUsageChecker.canUse((Method)m, clazz);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testMethodUnaccessibleClassParameter() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method m = this.getMethod(ExampleWithStaticPackagePrivateInnerClass.class, "setFoo");
        boolean result = TestUsageChecker.canUse((Method)m, ExampleWithStaticPackagePrivateInnerClass.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testAccessibleMethodInClassWithUnaccessibleClassParameterMethod() {
        Properties.CLASS_PREFIX = "some.package";
        Properties.TARGET_CLASS = "some.package.Foo";
        Method m = this.getMethod(ExampleWithStaticPackagePrivateInnerClass.class, "bar");
        boolean result = TestUsageChecker.canUse((Method)m, ExampleWithStaticPackagePrivateInnerClass.class);
        Assert.assertTrue((boolean)result);
    }
}

