/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import com.examples.with.different.packagename.staticusage.Bar1;
import com.examples.with.different.packagename.staticusage.Bar2;
import com.examples.with.different.packagename.staticusage.Bar3;
import com.examples.with.different.packagename.staticusage.Bar4;
import com.examples.with.different.packagename.staticusage.Bar5;
import com.examples.with.different.packagename.staticusage.Bar6;
import com.examples.with.different.packagename.staticusage.Bar7;
import com.examples.with.different.packagename.staticusage.BarBar1;
import com.examples.with.different.packagename.staticusage.Cycle1;
import com.examples.with.different.packagename.staticusage.Cycle2;
import com.examples.with.different.packagename.staticusage.Foo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.setup.GetStaticGraph;
import org.evosuite.setup.GetStaticGraphGenerator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGetStaticGraph {
    @BeforeClass
    public static void init() {
        String cp = System.getProperty("user.dir") + "/target/test-classes";
        ClassPathHandler.getInstance().addElementToTargetProjectClassPath(cp);
    }

    @Test
    public void testFoo() {
        String targetClassName = Foo.class.getCanonicalName();
        GetStaticGraph graph = GetStaticGraphGenerator.generate((String)targetClassName);
        HashSet<String> expectedClasses = new HashSet<String>(Arrays.asList(Foo.class.getCanonicalName(), Bar1.class.getCanonicalName(), Bar2.class.getCanonicalName(), Bar3.class.getCanonicalName(), Bar4.class.getCanonicalName(), Bar5.class.getCanonicalName(), Bar6.class.getCanonicalName(), Bar7.class.getCanonicalName(), BarBar1.class.getCanonicalName()));
        HashSet allClasses = new HashSet();
        allClasses.addAll(graph.getSourceClasses());
        allClasses.addAll(graph.getTargetClasses());
        Assert.assertEquals(expectedClasses, allClasses);
        HashMap<String, HashSet<String>> expectedStaticFields = new HashMap<String, HashSet<String>>();
        expectedStaticFields.put(Bar2.class.getCanonicalName(), new HashSet<String>(Arrays.asList("fieldBar2")));
        expectedStaticFields.put(Bar6.class.getCanonicalName(), new HashSet<String>(Arrays.asList("fieldBar6")));
        expectedStaticFields.put(Bar7.class.getCanonicalName(), new HashSet<String>(Arrays.asList("fieldBar7")));
        Map staticFields = graph.getStaticFields();
        Assert.assertEquals(expectedStaticFields, (Object)staticFields);
    }

    @Test
    public void testCycle() {
        String targetClassName = Cycle1.class.getCanonicalName();
        GetStaticGraph graph = GetStaticGraphGenerator.generate((String)targetClassName);
        HashSet<String> expectedSourceClasses = new HashSet<String>(Arrays.asList(Cycle1.class.getCanonicalName(), Cycle2.class.getCanonicalName()));
        Assert.assertEquals(expectedSourceClasses, (Object)graph.getSourceClasses());
        HashSet<String> expectedTargetClasses = expectedSourceClasses;
        Assert.assertEquals(expectedTargetClasses, (Object)graph.getTargetClasses());
        Map staticFields = graph.getStaticFields();
        Assert.assertTrue((boolean)staticFields.isEmpty());
    }
}

