/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup.callgraph;

import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.setup.DependencyAnalysis;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DependencyAnalysisTest {
    @BeforeClass
    public static void initialize() {
        Properties.TARGET_CLASS = "com.examples.with.different.packagename.context.complex.EntryPointsClass";
        Properties.CRITERION = new Properties.Criterion[1];
        Properties.CRITERION[0] = Properties.Criterion.IBRANCH;
        ArrayList<String> classpath = new ArrayList<String>();
        String cp = System.getProperty("user.dir") + "/target/test-classes";
        classpath.add(cp);
        ClassPathHandler.getInstance().addElementToTargetProjectClassPath(cp);
        try {
            DependencyAnalysis.analyzeClass((String)"com.examples.with.different.packagename.context.complex.EntryPointsClass", classpath);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void test1levelContext() {
        String context1 = DependencyAnalysis.getCallGraph().getAllContextsFromTargetClass("com.examples.with.different.packagename.context.complex.SubClass", "checkFiftneen(I)Z").toString();
        Assert.assertEquals((Object)context1, (Object)"[com.examples.with.different.packagename.context.complex.EntryPointsClass:dosmt(ILjava/lang/String;D)V com.examples.with.different.packagename.context.complex.SubClass:checkFiftneen(I)Z]");
    }

    @Test
    public void test2levelContext() {
        String context2 = DependencyAnalysis.getCallGraph().getAllContextsFromTargetClass("com.examples.with.different.packagename.context.complex.SubClass", "bla(I)Z").toString();
        Assert.assertEquals((Object)context2, (Object)"[com.examples.with.different.packagename.context.complex.EntryPointsClass:dosmt(ILjava/lang/String;D)V com.examples.with.different.packagename.context.complex.SubClass:checkFiftneen(I)Z com.examples.with.different.packagename.context.complex.SubClass:bla(I)Z]");
    }

    @Test
    public void test3levelContext() {
        String context2 = DependencyAnalysis.getCallGraph().getAllContextsFromTargetClass("com.examples.with.different.packagename.context.complex.SubSubClass", "innermethod(I)Z").toString();
        Assert.assertEquals((Object)context2, (Object)"[com.examples.with.different.packagename.context.complex.EntryPointsClass:dosmt(ILjava/lang/String;D)V com.examples.with.different.packagename.context.complex.SubClass:checkFiftneen(I)Z com.examples.with.different.packagename.context.complex.SubClass:bla(I)Z com.examples.with.different.packagename.context.complex.SubSubClass:innermethod(I)Z]");
    }

    @Test
    public void testContextInParamethers() {
        String context2 = DependencyAnalysis.getCallGraph().getAllContextsFromTargetClass("com.examples.with.different.packagename.context.complex.ParameterObject", "isEnabled()Z").toString();
        Assert.assertEquals((Object)context2, (Object)"[com.examples.with.different.packagename.context.complex.EntryPointsClass:doObj(Lcom/examples/with/different/packagename/context/complex/AParameterObject;)V com.examples.with.different.packagename.context.complex.ParameterObject:isEnabled()Z]");
    }
}

