/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.stubs;

import com.examples.with.different.packagename.Dummy;
import com.examples.with.different.packagename.NullString;
import com.examples.with.different.packagename.ReturnALocale;
import com.examples.with.different.packagename.SimpleInteger;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.evosuite.stubs.TestStubbingClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class TestStubInstrumentation {
    @Test
    public void testEmptyFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.Dummy");
        Class<Dummy> testClass = Dummy.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        boolean testResult = (Boolean)testClass.getMethod("isDummy", new Class[0]).invoke(testInstance, new Object[0]);
        boolean stubResult = (Boolean)stubClass.getMethod("isDummy", new Class[0]).invoke(stubInstance, new Object[0]);
        Assert.assertTrue((boolean)testResult);
        Assert.assertFalse((boolean)stubResult);
    }

    @Test
    public void testIntFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        int testResult = (Integer)testClass.getMethod("testInt", Integer.TYPE, Integer.TYPE).invoke(testInstance, 10, 10);
        int stubResult = (Integer)stubClass.getMethod("testInt", Integer.TYPE, Integer.TYPE).invoke(stubInstance, 10, 10);
        Assert.assertEquals((long)20L, (long)testResult);
        Assert.assertEquals((long)0L, (long)stubResult);
    }

    @Test
    public void testShortFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        short testResult = (Short)testClass.getMethod("testShort", Short.TYPE, Short.TYPE).invoke(testInstance, (short)10, (short)10);
        short stubResult = (Short)stubClass.getMethod("testShort", Short.TYPE, Short.TYPE).invoke(stubInstance, (short)10, (short)10);
        Assert.assertEquals((long)20L, (long)testResult);
        Assert.assertEquals((long)0L, (long)stubResult);
    }

    @Test
    public void testByteFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        byte testResult = (Byte)testClass.getMethod("testByte", Byte.TYPE, Byte.TYPE).invoke(testInstance, (byte)10, (byte)10);
        byte stubResult = (Byte)stubClass.getMethod("testByte", Byte.TYPE, Byte.TYPE).invoke(stubInstance, (byte)10, (byte)10);
        Assert.assertEquals((long)20L, (long)testResult);
        Assert.assertEquals((long)0L, (long)stubResult);
    }

    @Test
    public void testCharFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        char testResult = ((Character)testClass.getMethod("testChar", Character.TYPE, Character.TYPE).invoke(testInstance, Character.valueOf('\n'), Character.valueOf('\n'))).charValue();
        char stubResult = ((Character)stubClass.getMethod("testChar", Character.TYPE, Character.TYPE).invoke(stubInstance, Character.valueOf('\n'), Character.valueOf('\n'))).charValue();
        Assert.assertEquals((long)20L, (long)testResult);
        Assert.assertEquals((long)0L, (long)stubResult);
    }

    @Test
    public void testLongFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        long testResult = (Long)testClass.getMethod("testLong", Long.TYPE, Long.TYPE).invoke(testInstance, 10, 10);
        long stubResult = (Long)stubClass.getMethod("testLong", Long.TYPE, Long.TYPE).invoke(stubInstance, 10, 10);
        Assert.assertEquals((long)20L, (long)testResult);
        Assert.assertEquals((long)0L, (long)stubResult);
    }

    @Test
    public void testFloatFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        float testResult = ((Float)testClass.getMethod("testFloat", Float.TYPE, Float.TYPE).invoke(testInstance, Float.valueOf(10.0f), Float.valueOf(10.0f))).floatValue();
        float stubResult = ((Float)stubClass.getMethod("testFloat", Float.TYPE, Float.TYPE).invoke(stubInstance, Float.valueOf(10.0f), Float.valueOf(10.0f))).floatValue();
        Assert.assertEquals((double)20.0, (double)testResult, (double)0.1);
        Assert.assertEquals((double)0.0, (double)stubResult, (double)0.1);
    }

    @Test
    public void testDoubleFunction() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        double testResult = (Double)testClass.getMethod("testDouble", Double.TYPE, Double.TYPE).invoke(testInstance, 10, 10);
        double stubResult = (Double)stubClass.getMethod("testDouble", Double.TYPE, Double.TYPE).invoke(stubInstance, 10, 10);
        Assert.assertEquals((double)20.0, (double)testResult, (double)0.1);
        Assert.assertEquals((double)0.0, (double)stubResult, (double)0.1);
    }

    @Test
    public void testSingleParameter() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.NullString");
        Class<NullString> testClass = NullString.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        boolean testResult = (Boolean)testClass.getMethod("isNull", String.class).invoke(testInstance, new Object[]{null});
        boolean stubResult = (Boolean)stubClass.getMethod("isNull", String.class).invoke(stubInstance, new Object[]{null});
        Assert.assertTrue((boolean)testResult);
        Assert.assertFalse((boolean)stubResult);
        testResult = (Boolean)testClass.getMethod("isNull", String.class).invoke(testInstance, "test");
        stubResult = (Boolean)stubClass.getMethod("isNull", String.class).invoke(stubInstance, "test");
        Assert.assertFalse((boolean)testResult);
        Assert.assertFalse((boolean)stubResult);
    }

    @Test
    public void testObjectReturn() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.ReturnALocale");
        Class<ReturnALocale> testClass = ReturnALocale.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        Locale testResult = (Locale)testClass.getMethod("getLocale", Integer.TYPE).invoke(testInstance, 10);
        Locale stubResult = (Locale)stubClass.getMethod("getLocale", Integer.TYPE).invoke(stubInstance, 10);
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)testResult);
        Assert.assertNull((Object)stubResult);
    }

    @Test
    public void testArrayReturn() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.SimpleInteger");
        Class<SimpleInteger> testClass = SimpleInteger.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        int[] testResult = (int[])testClass.getMethod("testIntArray", Integer.TYPE, Integer.TYPE).invoke(testInstance, 10, 10);
        int[] stubResult = (int[])stubClass.getMethod("testIntArray", Integer.TYPE, Integer.TYPE).invoke(stubInstance, 10, 10);
        Assert.assertEquals((long)2L, (long)testResult.length);
        Assert.assertEquals((long)0L, (long)stubResult.length);
    }

    @Test
    public void testObjectArrayReturn() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestStubbingClassLoader classLoader = new TestStubbingClassLoader();
        Class<?> stubClass = classLoader.loadClass("com.examples.with.different.packagename.ReturnALocale");
        Class<ReturnALocale> testClass = ReturnALocale.class;
        Object stubInstance = stubClass.newInstance();
        Object testInstance = testClass.newInstance();
        Locale[] testResult = (Locale[])testClass.getMethod("getMoreLocales", new Class[0]).invoke(testInstance, new Object[0]);
        Locale[] stubResult = (Locale[])stubClass.getMethod("getMoreLocales", new Class[0]).invoke(stubInstance, new Object[0]);
        Assert.assertEquals((long)2L, (long)testResult.length);
        Assert.assertEquals((long)0L, (long)stubResult.length);
    }
}

