/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import com.examples.with.different.packagename.concolic.TestCaseWithFile;
import com.examples.with.different.packagename.concolic.TestCaseWithReset;
import com.examples.with.different.packagename.concolic.TestCaseWithURL;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.SymbolicObserverTest;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcolicExecutionEnvironmentTest {
    private static final boolean DEFAULT_RESET_STATIC_FIELDS = Properties.RESET_STATIC_FIELDS;
    private static final boolean DEFAULT_CLIENT_ON_THREAD = Properties.CLIENT_ON_THREAD;
    private static final boolean DEFAULT_PRINT_TO_SYSTEM = Properties.PRINT_TO_SYSTEM;
    private static final int DEFAULT_TIMEOUT = Properties.TIMEOUT;
    private static final int DEFAULT_CONCOLIC_TIMEOUT = Properties.CONCOLIC_TIMEOUT;
    private static final boolean DEFAULT_VFS = Properties.VIRTUAL_FS;
    private static final boolean DEFAULT_VNET = Properties.VIRTUAL_NET;
    private static final boolean DEFAULT_REPLACE_CALLS = Properties.REPLACE_CALLS;
    private static final boolean DEFAULT_MOCK_FRAMEWORK_ENABLED = MockFramework.isEnabled();

    private List<BranchCondition> executeTest(DefaultTestCase tc) {
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        return branch_conditions;
    }

    @Test
    public void testDseWithFile() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = ConcolicExecutionEnvironmentTest.buildTestCaseWithFile();
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertTrue((branch_conditions.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDseWithURL() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = ConcolicExecutionEnvironmentTest.buildTestCaseWithURL();
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertTrue((branch_conditions.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDseWithReset1() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = ConcolicExecutionEnvironmentTest.buildTestCaseWithReset();
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    @Test
    public void testDseWithReset2() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = ConcolicExecutionEnvironmentTest.buildTestCaseWithReset();
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertEquals((long)1L, (long)branch_conditions.size());
    }

    @After
    public void restore() {
        TestGenerationContext.getInstance().resetContext();
        RuntimeSettings.useVFS = DEFAULT_VFS;
        Properties.RESET_STATIC_FIELDS = DEFAULT_RESET_STATIC_FIELDS;
        Properties.REPLACE_CALLS = DEFAULT_REPLACE_CALLS;
        Properties.VIRTUAL_NET = DEFAULT_VNET;
        Properties.CLIENT_ON_THREAD = DEFAULT_CLIENT_ON_THREAD;
        Properties.PRINT_TO_SYSTEM = DEFAULT_PRINT_TO_SYSTEM;
        Properties.TIMEOUT = DEFAULT_TIMEOUT;
        Properties.CONCOLIC_TIMEOUT = DEFAULT_CONCOLIC_TIMEOUT;
        if (DEFAULT_MOCK_FRAMEWORK_ENABLED) {
            MockFramework.enable();
        } else {
            MockFramework.disable();
        }
    }

    private static DefaultTestCase buildTestCaseWithReset() throws SecurityException, NoSuchMethodException {
        Method isZeroMethod = TestCaseWithReset.class.getMethod("isZero", Integer.TYPE);
        Method incMethod = TestCaseWithReset.class.getMethod("inc", new Class[0]);
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(0);
        tc.appendMethod(null, isZeroMethod, int0);
        tc.appendMethod(null, incMethod, new VariableReference[0]);
        tc.appendMethod(null, incMethod, new VariableReference[0]);
        return tc.getDefaultTestCase();
    }

    private static DefaultTestCase buildTestCaseWithURL() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(10);
        VariableReference urlStringVarRef = tc.appendStringPrimitive("http://evosuite.org/hello.txt");
        Method urlMethod = MockURL.class.getMethod("URL", String.class);
        VariableReference mockURLVarRef = tc.appendMethod(null, urlMethod, urlStringVarRef);
        Constructor evoSuiteURLCtor = EvoSuiteURL.class.getConstructor(String.class);
        VariableReference evosuiteURL = tc.appendConstructor(evoSuiteURLCtor, urlStringVarRef);
        VariableReference string0VarRef = tc.appendStringPrimitive("<<FILE CONTENT>>");
        Method appendStringToFileMethod = NetworkHandling.class.getMethod("createRemoteTextFile", EvoSuiteURL.class, String.class);
        tc.appendMethod(null, appendStringToFileMethod, evosuiteURL, string0VarRef);
        Constructor ctor = TestCaseWithURL.class.getConstructor(new Class[0]);
        VariableReference testCaseWithURLVarRef = tc.appendConstructor(ctor, new VariableReference[0]);
        Method testMethod = TestCaseWithURL.class.getMethod("test", URL.class);
        tc.appendMethod(testCaseWithURLVarRef, testMethod, mockURLVarRef);
        Method isZeroMethod = TestCaseWithFile.class.getMethod("isZero", Integer.TYPE);
        tc.appendMethod(null, isZeroMethod, int0);
        return tc.getDefaultTestCase();
    }

    @Before
    public void init() {
        Properties.VIRTUAL_NET = true;
        Properties.REPLACE_CALLS = true;
        Properties.RESET_STATIC_FIELDS = true;
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000;
        Properties.CONCOLIC_TIMEOUT = 5000000;
        RuntimeSettings.useVFS = true;
        Runtime.getInstance().resetRuntime();
        TestCaseExecutor.getInstance().newObservers();
        TestCaseExecutor.initExecutor();
        MockFramework.enable();
        VirtualFileSystem.getInstance().resetSingleton();
        VirtualFileSystem.getInstance().init();
    }

    private static DefaultTestCase buildTestCaseWithFile() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(10);
        VariableReference prefixVarRef = tc.appendStringPrimitive("temp");
        VariableReference sufixVarRef = tc.appendStringPrimitive(".txt");
        Method createTempFileMethod = MockFile.class.getMethod("createTempFile", String.class, String.class);
        VariableReference mockFileVarRef = tc.appendMethod(null, createTempFileMethod, prefixVarRef, sufixVarRef);
        Method getPathMethod = MockFile.class.getMethod("getPath", new Class[0]);
        VariableReference pathVarRef = tc.appendMethod(mockFileVarRef, getPathMethod, new VariableReference[0]);
        Constructor evoSuiteFileCtor = EvoSuiteFile.class.getConstructor(String.class);
        VariableReference evosuiteFile = tc.appendConstructor(evoSuiteFileCtor, pathVarRef);
        VariableReference fileContentVarRef = tc.appendStringPrimitive("<<FILE CONTENT>>");
        Method appendStringToFileMethod = FileSystemHandling.class.getMethod("appendStringToFile", EvoSuiteFile.class, String.class);
        tc.appendMethod(null, appendStringToFileMethod, evosuiteFile, fileContentVarRef);
        Constructor ctor = TestCaseWithFile.class.getConstructor(new Class[0]);
        VariableReference dseWithFileVarRef = tc.appendConstructor(ctor, new VariableReference[0]);
        Method testMethod = TestCaseWithFile.class.getMethod("test", File.class);
        tc.appendMethod(dseWithFileVarRef, testMethod, mockFileVarRef);
        Method isZeroMethod = TestCaseWithFile.class.getMethod("isZero", Integer.TYPE);
        tc.appendMethod(null, isZeroMethod, int0);
        return tc.getDefaultTestCase();
    }
}

