/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ClassPrimitiveStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.environment.FileNamePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BytePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.CharPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.DoublePrimitiveStatement;
import org.evosuite.testcase.statements.numeric.FloatPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.LongPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.ShortPrimitiveStatement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericField;
import org.evosuite.utils.generic.GenericMethod;

public class TestCaseBuilder {
    private final DefaultTestCase tc = new DefaultTestCase();
    private final Map<Integer, Throwable> exceptions = new HashMap<Integer, Throwable>();

    public VariableReference appendConstructor(Constructor<?> constructor, VariableReference ... parameters) {
        List<VariableReference> parameter_list = Arrays.asList(parameters);
        ConstructorStatement constructorStmt = new ConstructorStatement((TestCase)this.tc, new GenericConstructor(constructor, constructor.getDeclaringClass()), parameter_list);
        this.tc.addStatement((Statement)constructorStmt);
        return constructorStmt.getReturnValue();
    }

    public VariableReference appendIntPrimitive(int intValue) {
        IntPrimitiveStatement primitiveStmt = new IntPrimitiveStatement((TestCase)this.tc, Integer.valueOf(intValue));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public String toCode() {
        return this.tc.toCode();
    }

    public VariableReference appendMethod(VariableReference callee, Method method, VariableReference ... parameters) {
        List<VariableReference> parameter_list = Arrays.asList(parameters);
        MethodStatement methodStmt = null;
        methodStmt = callee == null ? new MethodStatement((TestCase)this.tc, new GenericMethod(method, method.getDeclaringClass()), callee, parameter_list) : new MethodStatement((TestCase)this.tc, new GenericMethod(method, callee.getType()), callee, parameter_list);
        this.tc.addStatement((Statement)methodStmt);
        return methodStmt.getReturnValue();
    }

    public DefaultTestCase getDefaultTestCase() {
        return this.tc;
    }

    public VariableReference appendStringPrimitive(String string) {
        StringPrimitiveStatement primitiveStmt = new StringPrimitiveStatement((TestCase)this.tc, string);
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendBooleanPrimitive(boolean b) {
        BooleanPrimitiveStatement primitiveStmt = new BooleanPrimitiveStatement((TestCase)this.tc, Boolean.valueOf(b));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendDoublePrimitive(double d) {
        DoublePrimitiveStatement primitiveStmt = new DoublePrimitiveStatement((TestCase)this.tc, Double.valueOf(d));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public void appendAssignment(VariableReference receiver, Field field, VariableReference value) {
        FieldReference fieldReference = receiver == null ? new FieldReference((TestCase)this.tc, new GenericField(field, field.getDeclaringClass())) : new FieldReference((TestCase)this.tc, new GenericField(field, receiver.getType()), receiver);
        AssignmentStatement stmt = new AssignmentStatement((TestCase)this.tc, (VariableReference)fieldReference, value);
        this.tc.addStatement((Statement)stmt);
    }

    public VariableReference appendStaticFieldStmt(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        GenericField genericField = new GenericField(field, declaringClass);
        FieldStatement stmt = new FieldStatement((TestCase)this.tc, genericField, null);
        this.tc.addStatement((Statement)stmt);
        return stmt.getReturnValue();
    }

    public VariableReference appendFieldStmt(VariableReference receiver, Field field) {
        if (receiver == null) {
            throw new NullPointerException("Receiver object for a non-static field cannot be null");
        }
        FieldStatement stmt = new FieldStatement((TestCase)this.tc, new GenericField(field, receiver.getType()), receiver);
        this.tc.addStatement((Statement)stmt);
        return stmt.getReturnValue();
    }

    public VariableReference appendNull(Type type) {
        NullStatement stmt = new NullStatement((TestCase)this.tc, type);
        this.tc.addStatement((Statement)stmt);
        return stmt.getReturnValue();
    }

    public VariableReference appendEnumPrimitive(Enum<?> value) {
        EnumPrimitiveStatement primitiveStmt = new EnumPrimitiveStatement((TestCase)this.tc, value);
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public ArrayReference appendArrayStmt(Type type, int ... length) {
        ArrayStatement arrayStmt = new ArrayStatement((TestCase)this.tc, type, length);
        this.tc.addStatement((Statement)arrayStmt);
        return (ArrayReference)arrayStmt.getReturnValue();
    }

    public void appendAssignment(ArrayReference array, int index, VariableReference var) {
        ArrayIndex arrayIndex = new ArrayIndex((TestCase)this.tc, array, index);
        AssignmentStatement stmt = new AssignmentStatement((TestCase)this.tc, (VariableReference)arrayIndex, var);
        this.tc.addStatement((Statement)stmt);
    }

    public void appendAssignment(VariableReference var, ArrayReference array, int index) {
        ArrayIndex arrayIndex = new ArrayIndex((TestCase)this.tc, array, index);
        AssignmentStatement stmt = new AssignmentStatement((TestCase)this.tc, var, (VariableReference)arrayIndex);
        this.tc.addStatement((Statement)stmt);
    }

    public VariableReference appendLongPrimitive(long l) {
        LongPrimitiveStatement primitiveStmt = new LongPrimitiveStatement((TestCase)this.tc, Long.valueOf(l));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendFloatPrimitive(float f) {
        FloatPrimitiveStatement primitiveStmt = new FloatPrimitiveStatement((TestCase)this.tc, Float.valueOf(f));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendShortPrimitive(short s) {
        ShortPrimitiveStatement primitiveStmt = new ShortPrimitiveStatement((TestCase)this.tc, Short.valueOf(s));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendBytePrimitive(byte b) {
        BytePrimitiveStatement primitiveStmt = new BytePrimitiveStatement((TestCase)this.tc, Byte.valueOf(b));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendCharPrimitive(char c) {
        CharPrimitiveStatement primitiveStmt = new CharPrimitiveStatement((TestCase)this.tc, Character.valueOf(c));
        this.tc.addStatement((Statement)primitiveStmt);
        return primitiveStmt.getReturnValue();
    }

    public VariableReference appendClassPrimitive(Class<?> value) {
        ClassPrimitiveStatement stmt = new ClassPrimitiveStatement((TestCase)this.tc, value);
        this.tc.addStatement((Statement)stmt);
        return stmt.getReturnValue();
    }

    public VariableReference appendFileNamePrimitive(EvoSuiteFile evosuiteFile) {
        FileNamePrimitiveStatement stmt = new FileNamePrimitiveStatement((TestCase)this.tc, evosuiteFile);
        this.tc.addStatement((Statement)stmt);
        return stmt.getReturnValue();
    }

    public void appendAssignment(VariableReference receiver, Field field, VariableReference src, Field fieldSrc) {
        FieldReference dstFieldReference = receiver == null ? new FieldReference((TestCase)this.tc, new GenericField(field, field.getDeclaringClass())) : new FieldReference((TestCase)this.tc, new GenericField(field, receiver.getType()), receiver);
        FieldReference srcFieldReference = src == null ? new FieldReference((TestCase)this.tc, new GenericField(fieldSrc, fieldSrc.getDeclaringClass())) : new FieldReference((TestCase)this.tc, new GenericField(fieldSrc, src.getType()), src);
        AssignmentStatement stmt = new AssignmentStatement((TestCase)this.tc, (VariableReference)dstFieldReference, (VariableReference)srcFieldReference);
        this.tc.addStatement((Statement)stmt);
    }

    public void addException(Throwable exception) {
        int currentPos = this.tc.size() - 1;
        if (currentPos < 0) {
            throw new IllegalStateException("Cannot add exception to empty test case");
        }
        if (this.exceptions.containsKey(currentPos)) {
            throw new IllegalStateException("Statement already contains an exception!");
        }
        this.exceptions.put(currentPos, exception);
    }
}

