/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;

public abstract class TestSolver {
    public static Map<String, Object> solve(Solver solver, Collection<Constraint<?>> constraints) throws SolverTimeoutException {
        try {
            SolverResult solverResult = solver.solve(constraints);
            if (solverResult.isUNSAT()) {
                return null;
            }
            Map model = solverResult.getModel();
            return model;
        }
        catch (SolverEmptyQueryException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (SolverParseException e) {
            return null;
        }
        catch (SolverErrorException e) {
            return null;
        }
    }
}

