/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import com.examples.with.different.packagename.solver.TestCaseAbs;
import com.examples.with.different.packagename.solver.TestCaseMax;
import com.examples.with.different.packagename.solver.TestCaseMin;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.DefaultTestCaseConcolicExecutor;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.TestSolver;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.Assert;

public class TestSolverMath {
    private static DefaultTestCase buildTestCaseAbs() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(-2147483647);
        Method method = TestCaseAbs.class.getMethod("test", Integer.TYPE);
        tc.appendMethod(null, method, int0);
        return tc.getDefaultTestCase();
    }

    public static void testAbs(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMath.buildTestCaseAbs();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Long var0 = (Long)solution.get("var0");
        Assert.assertTrue((Math.abs(var0.intValue()) > 0 ? 1 : 0) != 0);
    }

    private static DefaultTestCase buildTestCaseMax() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MIN_VALUE);
        VariableReference int1 = tc.appendIntPrimitive(10);
        Method method = TestCaseMax.class.getMethod("test", Integer.TYPE, Integer.TYPE);
        tc.appendMethod(null, method, int0, int1);
        return tc.getDefaultTestCase();
    }

    private static DefaultTestCase buildTestCaseMin() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference int0 = tc.appendIntPrimitive(Integer.MAX_VALUE);
        VariableReference int1 = tc.appendIntPrimitive(10);
        Method method = TestCaseMin.class.getMethod("test", Integer.TYPE, Integer.TYPE);
        tc.appendMethod(null, method, int0, int1);
        return tc.getDefaultTestCase();
    }

    public static void testMax(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMath.buildTestCaseMax();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Long var0 = (Long)solution.get("var0");
        Long var1 = (Long)solution.get("var1");
        Assert.assertEquals((long)10L, (long)Math.max(var0.intValue(), var1.intValue()));
    }

    public static void testMin(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMath.buildTestCaseMin();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Long var0 = (Long)solution.get("var0");
        Long var1 = (Long)solution.get("var1");
        Assert.assertEquals((long)10L, (long)Math.min(var0.intValue(), var1.intValue()));
    }
}

