/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import com.examples.with.different.packagename.solver.TestCaseFloatAbs;
import com.examples.with.different.packagename.solver.TestCaseFloatMax;
import com.examples.with.different.packagename.solver.TestCaseFloatMin;
import com.examples.with.different.packagename.solver.TestCaseFloatRound;
import com.examples.with.different.packagename.solver.TestCaseFloatTrigonometry;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.solver.DefaultTestCaseConcolicExecutor;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.TestSolver;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.Assert;

public class TestSolverMathFloat {
    private static final double DELTA = 1.0E-15;

    private static DefaultTestCase buildTestCaseFloatAbs() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference double0 = tc.appendDoublePrimitive(-Math.PI);
        Method method = TestCaseFloatAbs.class.getMethod("test", Double.TYPE);
        tc.appendMethod(null, method, double0);
        return tc.getDefaultTestCase();
    }

    public static void testAbs(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMathFloat.buildTestCaseFloatAbs();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Double var0 = (Double)solution.get("var0");
        Assert.assertTrue((Math.abs(var0) > 0.0 ? 1 : 0) != 0);
    }

    private static DefaultTestCase buildTestCaseFloatTrigonometry() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference double0 = tc.appendDoublePrimitive(-Math.PI);
        Method method = TestCaseFloatTrigonometry.class.getMethod("test", Double.TYPE);
        tc.appendMethod(null, method, double0);
        return tc.getDefaultTestCase();
    }

    public static Map<String, Object> testTrigonometry(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMathFloat.buildTestCaseFloatTrigonometry();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        return solution;
    }

    private static DefaultTestCase buildTestCaseMax() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference double0 = tc.appendDoublePrimitive(Double.MIN_VALUE);
        VariableReference double1 = tc.appendDoublePrimitive(10.0);
        Method method = TestCaseFloatMax.class.getMethod("test", Double.TYPE, Double.TYPE);
        tc.appendMethod(null, method, double0, double1);
        return tc.getDefaultTestCase();
    }

    private static DefaultTestCase buildTestCaseMin() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference double0 = tc.appendDoublePrimitive(Double.MAX_VALUE);
        VariableReference double1 = tc.appendDoublePrimitive(10.0);
        Method method = TestCaseFloatMin.class.getMethod("test", Double.TYPE, Double.TYPE);
        tc.appendMethod(null, method, double0, double1);
        return tc.getDefaultTestCase();
    }

    public static void testMax(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMathFloat.buildTestCaseMax();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Double var0 = (Double)solution.get("var0");
        Double var1 = (Double)solution.get("var1");
        Assert.assertEquals((double)10.0, (double)Math.max(var0, var1), (double)1.0E-15);
    }

    public static void testMin(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMathFloat.buildTestCaseMin();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Double var0 = (Double)solution.get("var0");
        Double var1 = (Double)solution.get("var1");
        Assert.assertEquals((double)10.0, (double)Math.min(var0, var1), (double)1.0E-15);
    }

    private static DefaultTestCase buildTestCaseRound() throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference double0 = tc.appendDoublePrimitive(Math.PI);
        VariableReference int1 = tc.appendIntPrimitive((int)Math.round(Math.PI));
        Method method = TestCaseFloatRound.class.getMethod("test", Double.TYPE, Integer.TYPE);
        tc.appendMethod(null, method, double0, int1);
        return tc.getDefaultTestCase();
    }

    public static void testRound(Solver solver) throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        DefaultTestCase tc = TestSolverMathFloat.buildTestCaseRound();
        Collection<Constraint<?>> constraints = DefaultTestCaseConcolicExecutor.execute(tc);
        Map<String, Object> solution = TestSolver.solve(solver, constraints);
        Assert.assertNotNull(solution);
        Double var0 = (Double)solution.get("var0");
        Long var1 = (Long)solution.get("var1");
        Assert.assertEquals((long)Math.round(var0), (long)var1.intValue());
    }
}

