/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Collections;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.StringAVM;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.junit.Assert;
import org.junit.Test;

public class StringAVMTests
extends RandomizedTC {
    private List<Constraint<?>> getPatternConstraint(StringVariable var, String format) {
        StringConstant symb_regex = ExpressionFactory.buildNewStringConstant((String)format);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)symb_regex, Operator.PATTERNMATCHES, (Expression)var, Long.valueOf(0L));
        StringConstraint constraint = new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L));
        List<StringConstraint> constraints = Collections.singletonList(constraint);
        return constraints;
    }

    @Test
    public void testIssueWithOptional() throws SolverTimeoutException {
        String name = "addd";
        StringVariable var = new StringVariable(name, "");
        String format = "a.?c";
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        long start_time = System.currentTimeMillis();
        long timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        StringAVM avm = new StringAVM(var, constraints, start_time, timeout);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
    }

    @Test
    public void testSimpleRegexThreeDigits() throws SolverTimeoutException {
        String name = "foo";
        StringVariable var = new StringVariable(name, "");
        String format = "\\d\\d\\d";
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        long start_time = System.currentTimeMillis();
        long timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        StringAVM avm = new StringAVM(var, constraints, start_time, timeout);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
        String result = (String)var.getConcreteValue();
        Integer value = Integer.parseInt(result);
        Assert.assertTrue((String)("Value=" + result), (value >= 0 && value <= 999 ? 1 : 0) != 0);
    }

    @Test
    public void testInsertLeft() throws SolverTimeoutException {
        String name = "foo";
        String start = "abc";
        StringVariable var = new StringVariable(name, start);
        String format = "\\d\\d\\d" + start;
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        long start_time = System.currentTimeMillis();
        long timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        StringAVM avm = new StringAVM(var, constraints, start_time, timeout);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
        String result = (String)var.getConcreteValue();
        Assert.assertTrue((String)("Length=" + result.length()), (result.length() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((String)result, (boolean)result.endsWith(start));
    }

    @Test
    public void testInsertRight() throws SolverTimeoutException {
        String name = "foo";
        String start = "abc";
        StringVariable var = new StringVariable(name, start);
        String format = start + "\\d\\d\\d";
        List<Constraint<?>> constraints = this.getPatternConstraint(var, format);
        long start_time = System.currentTimeMillis();
        long timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
        StringAVM avm = new StringAVM(var, constraints, start_time, timeout);
        boolean succeded = avm.applyAVM();
        Assert.assertTrue((boolean)succeded);
        String result = (String)var.getConcreteValue();
        Assert.assertTrue((String)("Length=" + result.length()), (result.length() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((String)result, (boolean)result.startsWith(start));
    }
}

